/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.pull.PullRequestMergeStrategy;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequestMergeStrategy.class)
public class RestPullRequestMergeStrategy
extends RestLinkedMapEntity {
    public static final RestPullRequestMergeStrategy REQUEST_EXAMPLE = new RestPullRequestMergeStrategy("no-ff");
    public static final RestPullRequestMergeStrategy RESPONSE_EXAMPLE = new RestPullRequestMergeStrategy("Always create a merge commit", true, Optional.of("--no-ff"), "no-ff", "Merge commit");
    private static final String DESCRIPTION = "description";
    private static final String ENABLED = "enabled";
    private static final String FLAG = "flag";
    private static final String ID = "id";
    private static final String NAME = "name";

    public RestPullRequestMergeStrategy() {
    }

    public RestPullRequestMergeStrategy(PullRequestMergeStrategy strategy) {
        this(strategy.getDescription(), strategy.isEnabled(), strategy.getFlag(), strategy.getId(), strategy.getName());
    }

    private RestPullRequestMergeStrategy(Map<String, ?> values) {
        super(values);
    }

    private RestPullRequestMergeStrategy(String id) {
        this.put(ID, id);
    }

    private RestPullRequestMergeStrategy(String description, boolean enabled, Optional<String> flag, String id, String name) {
        this.put(DESCRIPTION, description);
        this.put(ENABLED, enabled);
        flag.ifPresent(f -> this.put(FLAG, f));
        this.put(ID, id);
        this.put(NAME, name);
    }

    @Nullable
    public static RestPullRequestMergeStrategy valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequestMergeStrategy) {
            return (RestPullRequestMergeStrategy)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequestMergeStrategy((Map)value);
        }
        return null;
    }

    @Nullable
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Nonnull
    public Optional<String> getFlag() {
        return Optional.ofNullable(this.getStringProperty(FLAG));
    }

    @Nullable
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Nullable
    public String getName() {
        return this.getStringProperty(NAME);
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED, true);
    }
}

