/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestDiffSegment;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=DiffHunk.class)
public class RestDiffHunk
extends RestMapEntity {
    public static final Function<DiffHunk, RestDiffHunk> REST_TRANSFORM = RestDiffHunk::new;
    public static final RestDiffHunk HUNK_EXAMPLE = new RestDiffHunk(1, 1, 1, 2, null, (List<RestDiffSegment>)ImmutableList.of((Object)((Object)RestDiffSegment.REMOVED_SOURCE_EXAMPLE), (Object)((Object)RestDiffSegment.ADDED_DEST_EXAMPLE)), false);
    public static final RestDiffHunk HUNK_EXAMPLE_COMMENTED = new RestDiffHunk(1, 1, 1, 2, null, (List<RestDiffSegment>)ImmutableList.of((Object)((Object)RestDiffSegment.REMOVED_SOURCE_EXAMPLE), (Object)((Object)RestDiffSegment.ADDED_DEST_EXAMPLE_COMMENTED)), false);

    public RestDiffHunk() {
    }

    public RestDiffHunk(DiffHunk hunk) {
        this(hunk.getSourceLine(), hunk.getSourceSpan(), hunk.getDestinationLine(), hunk.getDestinationSpan(), hunk.getContext().orElse(null), RestDiffHunk.transform((Iterable)hunk.getSegments(), RestDiffSegment.REST_TRANSFORM), hunk.isTruncated());
    }

    private RestDiffHunk(int sourceLine, int sourceSpan, int destinationLine, int destinationSpan, String context, List<RestDiffSegment> segments, boolean isTruncated) {
        this.putIfNotNull("context", context);
        this.putIfNotNull("sourceLine", sourceLine);
        this.putIfNotNull("sourceSpan", sourceSpan);
        this.putIfNotNull("destinationLine", destinationLine);
        this.putIfNotNull("destinationSpan", destinationSpan);
        this.putIfNotEmpty("segments", segments);
        this.putIfNotNull("truncated", isTruncated);
    }
}

