/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.pull.RestPullRequestRef;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequest.class)
public class RestPullRequest
extends RestLinkedMapEntity {
    public static final String AUTHOR = "author";
    public static final String CLOSED = "closed";
    public static final String CLOSED_DATE = "closedDate";
    public static final String CREATED_DATE = "createdDate";
    public static final String DESCRIPTION = "description";
    public static final String DESCRIPTION_AS_HTML = "descriptionAsHtml";
    public static final String FROM_REF = "fromRef";
    public static final String ID = "id";
    public static final String LOCKED = "locked";
    public static final String OPEN = "open";
    public static final String PARTICIPANTS = "participants";
    public static final String REVIEWERS = "reviewers";
    public static final String STATE = "state";
    public static final String TITLE = "title";
    public static final String TO_REF = "toRef";
    public static final String UPDATED_DATE = "updatedDate";
    public static final String VERSION = "version";
    public static final RestPullRequest REQUEST_EXAMPLE = new RestPullRequest(-1L, -1, "Talking Nerdy", "It\u2019s a kludge, but put the tuple from the database in the cache.", PullRequestState.OPEN, null, null, null, RestPullRequestRef.REQUEST_FEATURE_EXAMPLE, RestPullRequestRef.REQUEST_MASTER_EXAMPLE, false, null, Sets.newHashSet((Object[])new RestPullRequestParticipant[]{RestPullRequestParticipant.REQUEST_EXAMPLE_USER_ONLY}), null, null, null);
    public static final RestPullRequest REQUEST_EXAMPLE_UPDATE = new RestPullRequest(101L, 2, "Talking Nerdy", "It\u2019s a hack, but force AO to eagerly initialize to avoid deadlocks.", null, null, null, null, null, null, null, null, Sets.newHashSet((Object[])new RestPullRequestParticipant[]{RestPullRequestParticipant.REQUEST_EXAMPLE_USER_ONLY}), null, null, null);
    public static final RestPullRequest RESPONSE_EXAMPLE_BRAND_NEW = new RestPullRequest(101L, 1, "Talking Nerdy", "It\u2019s a kludge, but put the tuple from the database in the cache.", PullRequestState.OPEN, new Date(1359075920L), new Date(1359075920L), null, RestPullRequestRef.RESPONSE_FEATURE_EXAMPLE, RestPullRequestRef.RESPONSE_MASTER_EXAMPLE, false, RestPullRequestParticipant.newExample("alice", PullRequestRole.PARTICIPANT, PullRequestParticipantStatus.UNAPPROVED), Sets.newHashSet((Object[])new RestPullRequestParticipant[]{RestPullRequestParticipant.EXAMPLE_RESPONSE_REVIEWER_UNAPPROVED}), Sets.newHashSet(), null, RestDocUtils.selfLink(PullRequest.class));
    public static final RestPullRequest RESPONSE_EXAMPLE = new RestPullRequest(101L, 1, "Talking Nerdy", "It\u2019s a kludge, but put the tuple from the database in the cache.", PullRequestState.OPEN, new Date(1359075920L), new Date(1359085920L), null, RestPullRequestRef.REQUEST_FEATURE_EXAMPLE, RestPullRequestRef.REQUEST_MASTER_EXAMPLE, false, RestPullRequestParticipant.newExample("tom", PullRequestRole.AUTHOR, PullRequestParticipantStatus.APPROVED), Sets.newHashSet((Object[])new RestPullRequestParticipant[]{RestPullRequestParticipant.EXAMPLE_RESPONSE_REVIEWER_APPROVED}), Sets.newHashSet((Object[])new RestPullRequestParticipant[]{RestPullRequestParticipant.newExample("dick", PullRequestRole.PARTICIPANT, PullRequestParticipantStatus.UNAPPROVED), RestPullRequestParticipant.newExample("harry", PullRequestRole.PARTICIPANT, PullRequestParticipantStatus.APPROVED)}), PropertyMap.EMPTY, RestDocUtils.selfLink(PullRequest.class));
    public static final RestPullRequest RESPONSE_EXAMPLE_MERGED = new RestPullRequest(101L, 1, "Talking Nerdy", "It\u2019s a kludge, but put the tuple from the database in the cache.", PullRequestState.MERGED, new Date(1359075920L), new Date(1359115920L), new Date(1359115920L), RestPullRequestRef.REQUEST_FEATURE_EXAMPLE, RestPullRequestRef.REQUEST_MASTER_EXAMPLE, false, RestPullRequestParticipant.newExample("tom", PullRequestRole.AUTHOR, PullRequestParticipantStatus.APPROVED), Sets.newHashSet((Object[])new RestPullRequestParticipant[]{RestPullRequestParticipant.EXAMPLE_RESPONSE_REVIEWER_APPROVED}), Sets.newHashSet((Object[])new RestPullRequestParticipant[]{RestPullRequestParticipant.newExample("dick", PullRequestRole.PARTICIPANT, PullRequestParticipantStatus.APPROVED), RestPullRequestParticipant.newExample("harry", PullRequestRole.PARTICIPANT, PullRequestParticipantStatus.APPROVED)}), new PropertyMap.Builder().property("commentCount", (Object)3).build(), RestDocUtils.selfLink(PullRequest.class));
    public static final RestPage<RestPullRequest> PAGE_EXAMPLE = RestDocUtils.pageOf(RESPONSE_EXAMPLE);
    public static final Function<PullRequest, RestPullRequest> REST_TRANSFORM = RestPullRequest::new;

    public RestPullRequest() {
    }

    public RestPullRequest(PullRequest pullRequest) {
        this(pullRequest.getId(), pullRequest.getVersion(), pullRequest.getTitle(), pullRequest.getDescription(), pullRequest.getState(), pullRequest.getCreatedDate(), pullRequest.getUpdatedDate(), pullRequest.getClosedDate(), new RestPullRequestRef(pullRequest.getFromRef()), new RestPullRequestRef(pullRequest.getToRef()), pullRequest.isLocked(), new RestPullRequestParticipant(pullRequest.getAuthor()), RestPullRequest.getRestParticipants(pullRequest.getReviewers()), RestPullRequest.getRestParticipants(pullRequest.getParticipants()), pullRequest.getProperties(), null);
    }

    private RestPullRequest(Map<String, Object> values) {
        super(values);
    }

    private RestPullRequest(long id, int version, String title, String description, PullRequestState state, Date created, Date updated, Date closed, RestPullRequestRef from, RestPullRequestRef to, Boolean locked, RestPullRequestParticipant author, Set<RestPullRequestParticipant> reviewers, Set<RestPullRequestParticipant> participants, PropertyMap properties, RestNamedLink selfLink) {
        if (id > 0L) {
            this.put(ID, id);
        }
        if (version != -1) {
            this.put(VERSION, version);
        }
        this.putIfNotNull(TITLE, title);
        this.putIfNotNull(DESCRIPTION, description);
        if (state != null) {
            this.put(STATE, state);
            this.put(OPEN, state == PullRequestState.OPEN);
            this.put(CLOSED, state != PullRequestState.OPEN);
        }
        this.putIfNotNull(CREATED_DATE, created);
        this.putIfNotNull(UPDATED_DATE, updated);
        this.putIfNotNull(CLOSED_DATE, closed);
        this.putIfNotNull(FROM_REF, (Object)from);
        this.putIfNotNull(TO_REF, (Object)to);
        this.putIfNotNull(LOCKED, locked);
        this.putIfNotNull(AUTHOR, (Object)author);
        this.putIfNotNull(REVIEWERS, reviewers);
        this.putIfNotNull(PARTICIPANTS, participants);
        this.putIfNotEmpty("properties", (Map)properties);
        if (selfLink != null) {
            this.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", selfLink).build());
        }
    }

    public String getDescription() {
        return StringUtils.trimToNull((String)this.getStringProperty(DESCRIPTION));
    }

    public long getId() {
        return this.getLongProperty(ID);
    }

    public RestPullRequestRef getFromRef() {
        return RestPullRequestRef.valueOf(this.get(FROM_REF));
    }

    public Set<RestPullRequestParticipant> getReviewers() {
        return this.getParticipants(REVIEWERS);
    }

    public String getTitle() {
        return StringUtils.trimToNull((String)this.getStringProperty(TITLE));
    }

    public RestPullRequestRef getToRef() {
        return RestPullRequestRef.valueOf(this.get(TO_REF));
    }

    public int getVersion() {
        return this.getIntProperty(VERSION);
    }

    public boolean hasAuthor() {
        return this.containsKey(AUTHOR);
    }

    public boolean hasDescription() {
        return this.getStringProperty(DESCRIPTION) != null;
    }

    public boolean hasParticipants() {
        return this.containsKey(PARTICIPANTS);
    }

    public boolean hasReviewers() {
        return this.containsKey(REVIEWERS);
    }

    public boolean hasTitle() {
        return this.getTitle() != null;
    }

    public boolean hasVersion() {
        return this.containsKey(VERSION);
    }

    public void setHtmlDescription(String html) {
        this.put(DESCRIPTION_AS_HTML, html);
    }

    @Nullable
    public static RestPullRequest valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequest) {
            return (RestPullRequest)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequest((Map)value);
        }
        return null;
    }

    private Set<RestPullRequestParticipant> getParticipants(String key) {
        Collection<Object> rawReviewers;
        Object value = this.get(key);
        Collection<Object> collection = rawReviewers = value instanceof Collection ? (Collection)value : Collections.emptySet();
        if (!rawReviewers.isEmpty()) {
            HashSet<RestPullRequestParticipant> reviewers = new HashSet<RestPullRequestParticipant>(rawReviewers.size());
            for (Object rawReviewer : rawReviewers) {
                RestPullRequestParticipant reviewer = RestPullRequestParticipant.valueOf(rawReviewer);
                if (reviewer == null) continue;
                reviewers.add(reviewer);
            }
            return reviewers;
        }
        return Collections.emptySet();
    }

    private static Set<RestPullRequestParticipant> getRestParticipants(Set<PullRequestParticipant> participants) {
        return RestPullRequest.transform(participants, RestPullRequestParticipant.REST_TRANSFORM);
    }
}

