/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.user;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.avatar.AvatarAware;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.user.RestDetailedUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.Person;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Person.class)
public class RestPerson
extends RestMapEntity
implements AvatarAware,
Person {
    public static final Function<Person, RestPerson> REST_TRANSFORM = person -> {
        if (person == null) {
            return null;
        }
        if (person instanceof DetailedUser) {
            return new RestDetailedUser((DetailedUser)person);
        }
        if (person instanceof ApplicationUser) {
            return new RestApplicationUser((ApplicationUser)person);
        }
        return new RestPerson((Person)person);
    };
    public static final RestPerson EXAMPLE = new RestPerson("charlie", "charlie@example.com");
    public static final RestPerson EXAMPLE_NAME_ONLY = new RestPerson("charlie", null);
    public static final String EMAIL_ADDRESS = "emailAddress";
    public static final String NAME = "name";

    public RestPerson(Person author) {
        this(author.getName(), author.getEmailAddress());
    }

    protected RestPerson(String name, String emailAddress) {
        this.putIfNotNull(NAME, name);
        this.putIfNotNull(EMAIL_ADDRESS, emailAddress);
    }

    public RestPerson(Map<String, Object> map) {
        super(map);
    }

    public RestPerson() {
    }

    public String getEmailAddress() {
        return this.getStringProperty(EMAIL_ADDRESS);
    }

    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Override
    public void setAvatarUrl(String avatarUrl) {
        this.put("avatarUrl", avatarUrl);
    }
}

