/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.job;

import com.atlassian.bitbucket.job.JobMessage;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=JobMessage.class)
public class RestJobMessage
extends RestMapEntity {
    public static final String CREATED_DATE = "createdDate";
    public static final String ID = "id";
    public static final String SEVERITY = "severity";
    public static final String SUBJECT = "subject";
    public static final String TEXT = "text";
    public static final RestJobMessage RESPONSE_EXAMPLE = new RestJobMessage(new Date(1497657601250L), 617L, JobMessageSeverity.INFO, "job", "Something of interest happened");
    public static final RestJobMessage RESPONSE_EXAMPLE_WARN = new RestJobMessage(new Date(1497657601500L), 618L, JobMessageSeverity.WARN, "repo: PRJ/my-repo", "Something did not work perfectly");
    public static final RestJobMessage RESPONSE_EXAMPLE_ERROR = new RestJobMessage(new Date(1497657601750L), 619L, JobMessageSeverity.ERROR, "job", "Something has failed");
    public static final RestPage<RestJobMessage> PAGE_EXAMPLE = RestDocUtils.pageOf(RESPONSE_EXAMPLE, RESPONSE_EXAMPLE_WARN, RESPONSE_EXAMPLE_ERROR);

    public RestJobMessage(Map<String, ?> values) {
        super(values);
    }

    public RestJobMessage(@Nonnull JobMessage message) {
        Objects.requireNonNull(message, "message");
        this.put(CREATED_DATE, message.getCreatedDate().toEpochMilli());
        this.put(ID, message.getId());
        this.put(SEVERITY, message.getSeverity().name());
        message.getSubject().ifPresent(subject -> this.put(SUBJECT, subject));
        this.put(TEXT, message.getText());
    }

    public RestJobMessage(Date createdDate, long id, JobMessageSeverity severity, String subject, String text) {
        this.putIfNotNull(CREATED_DATE, createdDate);
        this.put(ID, id);
        this.putIfNotNull(SEVERITY, severity != null ? severity.name() : null);
        this.putIfNotNull(SUBJECT, subject);
        this.putIfNotNull(TEXT, text);
    }

    public Instant getCreatedDate() {
        return Instant.ofEpochMilli(this.getLongProperty(CREATED_DATE));
    }

    public String getId() {
        return this.getStringProperty(ID);
    }

    public JobMessageSeverity getSeverity() {
        return JobMessageSeverity.valueOf((String)this.getStringProperty(SEVERITY));
    }

    public String getSubject() {
        return this.getStringProperty(SUBJECT);
    }

    public String getText() {
        return this.getStringProperty(TEXT);
    }
}

