/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestConflict;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import java.util.Map;
import java.util.function.Function;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Change.class)
public class RestChange
extends RestLinkedMapEntity {
    public static final Function<Change, RestChange> REST_TRANSFORM = change -> change == null ? null : new RestChange((Change)change);
    public static final RestChange EXAMPLE = new RestChange("abcdef0123abcdef4567abcdef8987abcdef6543", "bcdef0123abcdef4567abcdef8987abcdef6543a", RestPath.fromPath((String)"new/path/to/file.txt"), Boolean.FALSE, RestPath.EXAMPLE, Boolean.FALSE, ChangeType.MOVE, ContentTreeNode.Type.FILE, 98, null, null, RestDocUtils.selfLink(RestChange.class));
    public static final RestPage<RestChange> PAGE_EXAMPLE = RestDocUtils.pageOf(EXAMPLE);

    public RestChange(Change change) {
        this(change, null);
    }

    public RestChange(Change change, NavBuilder.Commit commitNav) {
        this(change.getContentId(), change.getFromContentId(), RestPath.fromPath((Path)change.getPath()), change.getExecutable(), RestPath.fromPath((Path)change.getSrcPath()), change.getSrcExecutable(), change.getType(), change.getNodeType(), change.getPercentUnchanged(), RestConflict.fromConflict(change.getConflict()), change.getProperties(), commitNav == null ? null : new RestNamedLink(commitNav.change(change.getPath()).buildAbsolute()));
    }

    private RestChange(String contentId, String fromContentId, RestPath path, Boolean executable, RestPath srcPath, Boolean srcExecutable, ChangeType type, ContentTreeNode.Type nodeType, int percentUnchanged, RestConflict conflict, PropertyMap properties, RestNamedLink selfLink) {
        this.put("contentId", contentId);
        this.put("fromContentId", fromContentId);
        this.put("path", path);
        this.putIfNotNull("executable", executable);
        this.put("percentUnchanged", percentUnchanged);
        this.put("type", type);
        this.put("nodeType", nodeType);
        this.putIfNotNull("srcPath", srcPath);
        this.putIfNotNull("srcExecutable", srcExecutable);
        this.putIfNotNull("conflict", (Object)conflict);
        this.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", selfLink).build());
        this.putIfNotEmpty("properties", (Map)properties);
    }

    public static Function<Change, RestChange> transform() {
        return REST_TRANSFORM;
    }

    public static Function<Change, RestChange> transform(final NavBuilder.Commit nav) {
        if (nav == null) {
            return RestChange.transform();
        }
        return new Function<Change, RestChange>(){

            @Override
            public RestChange apply(Change change) {
                return new RestChange(change, nav);
            }
        };
    }
}

