/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.repository;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.pull.RestPullRequestMergeConfig;
import javax.annotation.Nullable;

public class RestRepositoryPullRequestSettings
extends RestMapEntity {
    private static final String MERGE_CONFIG = "mergeConfig";
    private static final String REQUIRED_ALL_APPROVERS = "requiredAllApprovers";
    private static final String REQUIRED_ALL_TASKS_COMPLETE = "requiredAllTasksComplete";
    private static final String REQUIRED_APPROVERS = "requiredApprovers";
    private static final String REQUIRED_SUCCESSFUL_BUILDS = "requiredSuccessfulBuilds";
    public static final RestRepositoryPullRequestSettings REQUEST_EXAMPLE = new RestRepositoryPullRequestSettings(false, false, 2, 0, RestPullRequestMergeConfig.REQUEST_EXAMPLE);
    public static final RestRepositoryPullRequestSettings RESPONSE_EXAMPLE = new RestRepositoryPullRequestSettings(false, false, 2, 0, RestPullRequestMergeConfig.RESPONSE_EXAMPLE);

    public RestRepositoryPullRequestSettings() {
    }

    private RestRepositoryPullRequestSettings(boolean requiredAllApprovers, boolean requiredAllTasksComplete, int requiredApprovers, int requiredSuccessfulBuilds, RestPullRequestMergeConfig mergeConfig) {
        this.put(MERGE_CONFIG, (Object)mergeConfig);
        this.put(REQUIRED_ALL_APPROVERS, requiredAllApprovers);
        this.put(REQUIRED_ALL_TASKS_COMPLETE, requiredAllTasksComplete);
        this.put(REQUIRED_APPROVERS, requiredApprovers);
        this.put(REQUIRED_SUCCESSFUL_BUILDS, requiredSuccessfulBuilds);
    }

    @Nullable
    public RestPullRequestMergeConfig getMergeConfig() {
        return RestPullRequestMergeConfig.valueOf(this.get(MERGE_CONFIG));
    }

    public boolean getRequiredAllApprovers() {
        return this.getBoolProperty(REQUIRED_ALL_APPROVERS);
    }

    public boolean getRequiredAllTasksComplete() {
        return this.getBoolProperty(REQUIRED_ALL_TASKS_COMPLETE);
    }

    public int getRequiredApprovers() {
        return this.getIntProperty(REQUIRED_APPROVERS);
    }

    public int getRequiredSuccessfulBuilds() {
        return this.getIntProperty(REQUIRED_SUCCESSFUL_BUILDS);
    }
}

