/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.util;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.io.ByteStreams;
import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.spi.container.ContainerRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.StringUtils;

public abstract class RestUtils {
    private static final Pattern COMMIT_ID_PATTERN = Pattern.compile("[0-9a-f]{40}", 2);
    private static final String CHARSET_UTF8 = ";charset=UTF-8";
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final String TEXT_HTML_UTF8 = "text/html;charset=UTF-8";
    public static final String DEFAULT_LIMIT = "25";
    public static final String DEFAULT_START = "0";
    public static final int DEFAULT_RECENT_REPOS_LIMIT = 15;
    public static final String DEFAULT_ENTITY_VERSION = "-1";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CHARSET_PREFIX = "charset=";
    private static final int LIMIT = Integer.parseInt("25");
    private static final int START = Integer.parseInt("0");
    private static final String OPTION_AVATAR_SIZE = "avatarSize";
    private static final String OPTION_AVATAR_SCHEME = "avatarScheme";
    private static final String OPTION_AVATAR_URL_MODE = "avatarUrlMode";
    private static final String URL_MODE_ABSOLUTE = "absolute";

    public static AvatarRequest makeAvatarRequest(ContainerRequest request) {
        MultivaluedMap parameters = request.getQueryParameters();
        if (parameters.containsKey((Object)OPTION_AVATAR_SIZE)) {
            String scheme = (String)parameters.getFirst((Object)OPTION_AVATAR_SCHEME);
            boolean secure = StringUtils.isEmpty((CharSequence)scheme) ? request.isSecure() : "https".equalsIgnoreCase(scheme);
            String urlMode = StringUtils.stripToNull((String)((String)parameters.getFirst((Object)OPTION_AVATAR_URL_MODE)));
            boolean isAbsolute = URL_MODE_ABSOLUTE.equalsIgnoreCase(urlMode);
            try {
                int size = Integer.parseInt((String)parameters.getFirst((Object)OPTION_AVATAR_SIZE));
                return new AvatarRequest(secure, size, isAbsolute);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static AvatarRequest makeAvatarRequest(@Nonnull RequestManager requestManager, @Nonnull Map<String, Object> options) {
        Object avatarSize = options.get(OPTION_AVATAR_SIZE);
        Integer size = 64;
        if (avatarSize != null) {
            if (avatarSize instanceof Number) {
                size = ((Number)avatarSize).intValue();
            } else if (avatarSize instanceof String) {
                try {
                    size = Integer.valueOf((String)avatarSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String scheme = (String)options.get(OPTION_AVATAR_SCHEME);
        RequestContext context = requestManager.getRequestContext();
        boolean secure = scheme != null ? "https".equals(scheme) : context == null || context.isSecure();
        String urlMode = StringUtils.stripToNull((String)Objects.toString(options.get(OPTION_AVATAR_URL_MODE), null));
        boolean isAbsolute = URL_MODE_ABSOLUTE.equalsIgnoreCase(urlMode);
        return new AvatarRequest(secure, size.intValue(), isAbsolute);
    }

    public static PageRequest makePageRequest(HttpRequestContext request) {
        return RestUtils.makePageRequest(request, LIMIT);
    }

    public static PageRequest makePageRequest(HttpRequestContext request, int defaultLimit) {
        MultivaluedMap parameters = request.getQueryParameters();
        String value = parameters.containsKey((Object)"limit") ? (String)parameters.getFirst((Object)"limit") : (String)parameters.getFirst((Object)"pageSize");
        int start = parameters.containsKey((Object)"start") ? Integer.parseInt((String)parameters.getFirst((Object)"start")) : START;
        int limit = value == null ? defaultLimit : Integer.parseInt(value);
        return PageUtils.newRequest((int)start, (int)limit);
    }

    public static boolean isImmutableObjectId(String objectId) {
        return objectId != null && COMMIT_ID_PATTERN.matcher(objectId).matches();
    }

    public static boolean isImmutableBetween(String untilId, String sinceId) {
        return RestUtils.isImmutableObjectId(untilId) && (sinceId == null || RestUtils.isImmutableObjectId(sinceId));
    }

    public static <T> T notFoundIfNull(T t) throws NotFoundException {
        if (t == null) {
            throw new NotFoundException();
        }
        return t;
    }

    public static <F, T> T applyOrNull(F from, Function<F, T> function) {
        if (from == null) {
            return null;
        }
        return function.apply(from);
    }

    public static String getOrDefaultBranch(RefService refService, Repository repository, String at) {
        return StringUtils.isBlank((CharSequence)at) ? refService.getDefaultBranch(repository).getId() : at;
    }

    public static Charset getCharset(ContainerRequest request, Charset defaultCharset) {
        int p;
        String contentType = StringUtils.lowerCase((String)request.getHeaderValue(CONTENT_TYPE));
        if (contentType != null && (p = contentType.indexOf(CHARSET_PREFIX)) != -1) {
            return RestUtils.getCharset(contentType.substring(p + CHARSET_PREFIX.length()), defaultCharset);
        }
        return defaultCharset;
    }

    private static Charset getCharset(String charset, Charset defaultCharset) {
        try {
            return Charset.forName(charset);
        }
        catch (IllegalCharsetNameException e) {
            return defaultCharset;
        }
        catch (UnsupportedCharsetException e) {
            return defaultCharset;
        }
    }

    public static Object processEntities(Object entity, Function<Object, Object> processCallback) {
        Collection entities;
        if (entity instanceof JsonStreamingOutput) {
            return RestUtils.processStreamingOutput((JsonStreamingOutput)entity, processCallback);
        }
        if ((entity = processCallback.apply(entity)) instanceof Page) {
            entities = ((Page)entity).getValues();
        } else if (entity instanceof Iterable) {
            entities = (Iterable)entity;
        } else if (entity instanceof RestMapEntity) {
            entities = ((RestMapEntity)entity).values();
        } else {
            return entity;
        }
        for (Object o : entities) {
            RestUtils.processEntities(o, processCallback);
        }
        return entity;
    }

    private static JsonStreamingOutput processStreamingOutput(final JsonStreamingOutput output, final Function<Object, Object> processCallback) {
        return new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                output.write(writer.transform(input -> RestUtils.processEntities(input, processCallback)));
            }
        };
    }

    public static Response processAvatarResponse(ContainerRequest request, CacheControl cacheControl, CacheableAvatarSupplier supplier) {
        return RestUtils.doConditionalGet((Request)request, new Date(supplier.getTimestamp()), builder -> {
            String contentType = supplier.getContentType();
            if (contentType != null) {
                builder.variant(new Variant(MediaType.valueOf((String)contentType), request.getLanguage(), null));
            }
            return builder.entity(outputStream -> {
                try (InputStream inputStream = supplier.open();){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                outputStream.flush();
            }).cacheControl(cacheControl);
        });
    }

    public static Response doConditionalGet(Request request, Date lastUpdate, Function<Response.ResponseBuilder, Response.ResponseBuilder> okFunction) {
        Response.ResponseBuilder rb = request.evaluatePreconditions(lastUpdate);
        if (rb != null) {
            return rb.build();
        }
        return okFunction.apply(Response.ok().lastModified(lastUpdate)).build();
    }
}

