define('bitbucket/internal/feature/sync/common/ref-sync-common', [
    'bitbucket/util/navbuilder',
    'bitbucket/util/server',
    'exports',
], function(
    nav,
    server,
    exports
) {
    'use strict';

    function enableRefSyncing(enable) {
        return server.rest({
            url: nav.rest('sync').currentRepo().build(),
            type: 'POST',
            data: {
                enabled: enable,
            },
        });
    }

    function getSyncUrl() {
        return nav.rest('sync').currentRepo().addPathComponents('synchronize').build();
    }

    exports.enableRefSyncing = enableRefSyncing;
    exports.getSyncUrl = getSyncUrl;
});
