/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.git.GitAgent;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.command.AbstractSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.ReviewRefsCommandParameters;

public class ReviewRefsCommand
extends AbstractSynchronizeRefsCommand<ReviewRefsCommandParameters> {
    public ReviewRefsCommand(GitAgent agent, GitCommandBuilderFactory builderFactory, RefSyncConfig config, ReviewRefsCommandParameters parameters) {
        super(agent, builderFactory, config, parameters);
    }

    @Override
    protected boolean synchronize() {
        for (RefChange change : (ReviewRefsCommandParameters)this.parameters) {
            RejectedRefState state = this.calculateState(change);
            if (state == null) {
                this.addChangedRef(change);
                continue;
            }
            this.addRejectedRef(change.getRef().getId(), state);
        }
        return false;
    }

    private RejectedRefState calculateState(RefChange change) {
        RefChangeType changeType = change.getType();
        if (changeType == RefChangeType.DELETE) {
            return null;
        }
        return this.calculateState(change.getRef().getId(), change.getToHash());
    }
}

