/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.git.GitAgent;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.RefSyncResult;
import com.atlassian.stash.internal.repository.sync.command.DiscardRefCommand;
import com.atlassian.stash.internal.repository.sync.command.DiscardRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.FullSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.IncrementalSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.MergeRefCommand;
import com.atlassian.stash.internal.repository.sync.command.MergeRefCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.RefSyncCommandFactory;
import com.atlassian.stash.internal.repository.sync.command.ReviewRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.ReviewRefsCommandParameters;
import com.atlassian.stash.internal.repository.sync.command.SynchronizeRefsCommandParameters;
import javax.annotation.Nonnull;

public class GitRefSyncCommandFactory
implements RefSyncCommandFactory {
    private final GitAgent agent;
    private final GitCommandBuilderFactory builderFactory;
    private final GitCommandFactory commandFactory;
    private final RefSyncConfig config;
    private final I18nService i18nService;

    public GitRefSyncCommandFactory(GitAgent agent, GitCommandBuilderFactory builderFactory, GitCommandFactory commandFactory, RefSyncConfig config, I18nService i18nService) {
        this.agent = agent;
        this.builderFactory = builderFactory;
        this.commandFactory = commandFactory;
        this.config = config;
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public Command<RefChange> discardRef(@Nonnull DiscardRefCommandParameters parameters) {
        return new DiscardRefCommand(this.agent, this.builderFactory, parameters);
    }

    @Override
    @Nonnull
    public Command<RefChange> mergeRef(@Nonnull MergeRefCommandParameters parameters) {
        return new MergeRefCommand(this.agent, this.commandFactory, this.i18nService, parameters);
    }

    @Override
    @Nonnull
    public Command<RefSyncResult> reviewRefs(@Nonnull ReviewRefsCommandParameters parameters) {
        return new ReviewRefsCommand(this.agent, this.builderFactory, this.config, parameters);
    }

    @Override
    @Nonnull
    public Command<RefSyncResult> synchronizeRefs(@Nonnull SynchronizeRefsCommandParameters parameters) {
        if (parameters.isFull()) {
            return new FullSynchronizeRefsCommand(this.agent, this.builderFactory, this.config, this.i18nService, parameters);
        }
        return new IncrementalSynchronizeRefsCommand(this.agent, this.builderFactory, this.config, this.i18nService, parameters);
    }
}

