/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.auto;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncOperation;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncRequest;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AutoRefSyncTask {
    private final AutoRefSyncOperation operation;
    private final List<RefChange> refChanges;

    private AutoRefSyncTask(AutoRefSyncRequest task) {
        this(task.getRefChanges(), task.getOperation());
    }

    private AutoRefSyncTask(List<RefChange> refChanges, AutoRefSyncOperation operation) {
        this.operation = operation;
        this.refChanges = refChanges;
    }

    @Nonnull
    public static List<AutoRefSyncTask> merge(@Nullable List<AutoRefSyncRequest> requests) {
        if (requests == null || requests.isEmpty()) {
            return Collections.emptyList();
        }
        if (requests.size() == 1) {
            return ImmutableList.of((Object)new AutoRefSyncTask(requests.get(0)));
        }
        HashMap operationsByRef = Maps.newHashMap();
        Multimap<String, RefChange> changesByRef = AutoRefSyncTask.mapChangesByRef(requests, operationsByRef);
        ArrayList firstPass = Lists.newArrayListWithCapacity((int)changesByRef.keySet().size());
        ArrayList secondPass = Lists.newArrayList();
        ArrayList reviewPass = Lists.newArrayList();
        for (Collection changes : changesByRef.asMap().values()) {
            if (AutoRefSyncOperation.REVIEW.equals(operationsByRef.get(((RefChange)Iterables.getFirst((Iterable)changes, null)).getRef().getId()))) {
                reviewPass.add(Iterables.getLast((Iterable)changes));
                continue;
            }
            if (changes.size() == 1) {
                firstPass.addAll(changes);
                continue;
            }
            AutoRefSyncTask.mergeChanges(changes, firstPass, secondPass);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!firstPass.isEmpty()) {
            builder.add((Object)new AutoRefSyncTask(firstPass, AutoRefSyncOperation.SYNCHRONIZE));
            if (!secondPass.isEmpty()) {
                builder.add((Object)new AutoRefSyncTask(secondPass, AutoRefSyncOperation.SYNCHRONIZE));
            }
        }
        if (!reviewPass.isEmpty()) {
            builder.add((Object)new AutoRefSyncTask(reviewPass, AutoRefSyncOperation.REVIEW));
        }
        return builder.build();
    }

    @Nonnull
    public AutoRefSyncOperation getOperation() {
        return this.operation;
    }

    @Nonnull
    public List<RefChange> getRefChanges() {
        return this.refChanges;
    }

    private static Multimap<String, RefChange> mapChangesByRef(List<AutoRefSyncRequest> requests, Map<String, AutoRefSyncOperation> operationsByRef) {
        ArrayListMultimap changesByRef = ArrayListMultimap.create();
        for (AutoRefSyncRequest request : requests) {
            AutoRefSyncOperation operation = request.getOperation();
            for (RefChange change : request.getRefChanges()) {
                operationsByRef.put(change.getRef().getId(), operation);
                changesByRef.put((Object)change.getRef().getId(), (Object)change);
            }
        }
        return changesByRef;
    }

    private static void mergeChanges(Collection<RefChange> changes, List<RefChange> firstPass, List<RefChange> secondPass) {
        SimpleRefChange.Builder first = null;
        SimpleRefChange.Builder second = null;
        boolean forSecond = false;
        for (RefChange change : changes) {
            if (first == null) {
                first = new SimpleRefChange.Builder(change);
            }
            if (change.getType() == RefChangeType.DELETE) {
                if (first.build().getType() == RefChangeType.ADD) {
                    second = null;
                    first = null;
                    forSecond = false;
                    continue;
                }
                forSecond = true;
                second = null;
                first.toHash(change.getToHash()).type(RefChangeType.DELETE);
                continue;
            }
            if (forSecond) {
                second = new SimpleRefChange.Builder(change);
                forSecond = false;
                continue;
            }
            (second == null ? first : second).toHash(change.getToHash());
        }
        if (first != null) {
            firstPass.add((RefChange)first.build());
            if (second != null) {
                secondPass.add((RefChange)second.build());
            }
        }
    }
}

