/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.auto;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.sync.RefsSynchronizedEvent;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncOperation;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncProcessor;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncRequest;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRefSyncListener {
    public static final String EXECUTOR_NAME = "ref-sync";
    private static final Function<AutoRefSyncRequest, String> TO_BUCKET_ID = request -> String.valueOf(request.getRepositoryId());
    private static final Logger log = LoggerFactory.getLogger(AutoRefSyncListener.class);
    private final RefSyncConfig config;
    private final ExecutorService queueExecutor;
    private final Predicate<Repository> isEnabled = new Predicate<Repository>(){

        public boolean apply(Repository repository) {
            return AutoRefSyncListener.this.syncService.isEnabled(repository);
        }
    };
    private final RepositoryService repositoryService;
    private final BucketedExecutor<AutoRefSyncRequest> syncExecutor;
    private final InternalRefSyncService syncService;
    private final EscalatedSecurityContext withRepoRead;

    public AutoRefSyncListener(ConcurrencyService concurrencyService, RefSyncConfig config, ExecutorService executorService, RepositoryService repositoryService, SecurityService securityService, AutoRefSyncProcessor syncProcessor, InternalRefSyncService syncService) {
        this.config = config;
        this.repositoryService = repositoryService;
        this.syncService = syncService;
        this.queueExecutor = executorService;
        this.syncExecutor = concurrencyService.getBucketedExecutor(EXECUTOR_NAME, new BucketedExecutorSettings.Builder(TO_BUCKET_ID, (BucketProcessor)syncProcessor).batchSize(Integer.MAX_VALUE).maxAttempts(1).maxConcurrency(config.getThreadCount(), ConcurrencyPolicy.PER_CLUSTER).build());
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "Retrieving forks for synchronization");
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        List refChanges = (List)event.getRefChanges().stream().filter(AutoRefSyncListener::isStandardRef).collect(MoreCollectors.toImmutableList());
        if (this.config.isPossible() && AutoRefSyncListener.isSynchronizable(event, refChanges)) {
            this.queueExecutor.submit(new QueueForksOperation(event, refChanges));
        } else {
            log.debug("Ignoring event; synchronization is not possible");
        }
    }

    public void shutdown() {
        ExecutorUtils.shutdown((ExecutorService)this.queueExecutor, (Logger)log);
        this.syncExecutor.shutdown();
    }

    private static boolean isStandardRef(RefChange refChange) {
        return AutoRefSyncListener.startsWith(refChange, GitRefPattern.HEADS) || AutoRefSyncListener.startsWith(refChange, GitRefPattern.TAGS);
    }

    private static boolean isSynchronizable(RepositoryRefsChangedEvent event, List<RefChange> refChanges) {
        Repository repository = event.getRepository();
        if (!"git".equals(repository.getScmId())) {
            log.trace("{}: Synchronization is only supported for Git repositories", (Object)repository);
            return false;
        }
        if (refChanges.isEmpty()) {
            log.trace("{}: No refs were changed; synchronization is not necessary", (Object)repository);
            return false;
        }
        if (event.getUser() == null) {
            log.debug("{}: Not synchronizing {} change(s); there is no associated user", (Object)repository, (Object)refChanges.size());
            return false;
        }
        return true;
    }

    private static boolean startsWith(RefChange refChange, GitRefPattern refPattern) {
        return refChange.getRef().getId().startsWith(refPattern.getPath());
    }

    private class QueueForksOperation
    implements PageProvider<Repository>,
    Runnable,
    UncheckedOperation<Void> {
        private final AutoRefSyncRequest.Builder builder;
        private final RepositoryRefsChangedEvent event;
        private final Repository repository;

        private QueueForksOperation(RepositoryRefsChangedEvent event, List<RefChange> refChanges) {
            this.event = event;
            this.builder = new AutoRefSyncRequest.Builder(refChanges, event.getUser());
            this.repository = event.getRepository();
        }

        public Page<Repository> get(PageRequest pageRequest) {
            return PageUtils.asPageOf(Repository.class, (Page)AutoRefSyncListener.this.repositoryService.findByOrigin(this.repository, pageRequest));
        }

        @Override
        public void run() {
            try (Timer ignored = TimerUtils.start((String)(this.repository.getId() + ": Queueing forks for synchronization"));){
                AutoRefSyncListener.this.withRepoRead.call((Operation)this);
            }
            if (this.event instanceof RefsSynchronizedEvent) {
                log.trace("{}: Not updating status after RefsSynchronizedEvent", (Object)this.repository);
            } else if (AutoRefSyncListener.this.syncService.isAvailable(this.repository) && AutoRefSyncListener.this.syncService.isEnabled(this.repository)) {
                this.builder.operation(AutoRefSyncOperation.REVIEW).repository(this.repository).upstream(this.repository.getOrigin());
                AutoRefSyncListener.this.syncExecutor.schedule((Serializable)this.builder.build(), 30L, TimeUnit.SECONDS);
            } else {
                log.debug("{}: Not updating status; synchronization is either not enabled or not available", (Object)this.repository);
            }
        }

        public Void perform() {
            this.builder.operation(AutoRefSyncOperation.SYNCHRONIZE).upstream(this.repository);
            for (Repository fork : Iterables.filter((Iterable)new PagedIterable((PageProvider)this, 25), (Predicate)AutoRefSyncListener.this.isEnabled)) {
                if (AutoRefSyncListener.this.syncService.isAvailable(fork)) {
                    AutoRefSyncListener.this.syncExecutor.schedule((Serializable)this.builder.repository(fork).build(), AutoRefSyncListener.this.config.getSyncDelay(), TimeUnit.SECONDS);
                    continue;
                }
                log.debug("{}: Not synchronizing with {}; synchronization is no longer available", (Object)fork, (Object)this.repository);
            }
            return null;
        }
    }
}

