/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.utils.process.LineOutputHandler;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateRevListCommandOutputHandler
extends LineOutputHandler
implements CommandOutputHandler<RejectedRefState> {
    private static final Logger log = LoggerFactory.getLogger(StateRevListCommandOutputHandler.class);
    private RejectedRefState state;

    @Nullable
    public RejectedRefState getOutput() {
        return this.state;
    }

    protected void processLine(int lineNum, String line) {
        int split = line.indexOf("\t");
        if (split == -1) {
            throw new IllegalStateException("Output [" + line + "] does not match the expected format");
        }
        int localCount = Integer.parseInt(line.substring(0, split));
        int upstreamCount = Integer.parseInt(line.substring(split + 1));
        if (upstreamCount > 0) {
            if (localCount > 0) {
                this.state = RejectedRefState.DIVERGED;
            } else {
                log.debug("That's odd; the local branch is still behind its upstream?");
            }
        } else if (localCount > 0) {
            this.state = RejectedRefState.AHEAD;
        } else {
            log.debug("That's odd; the local branch is in sync with its upstream?");
        }
    }
}

