/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitScmConfig;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class DefaultRefSyncConfig
implements RefSyncConfig {
    public static final int DEFAULT_COMMAND_SIZE = 32000;
    public static final long DEFAULT_FETCH_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final long DEFAULT_MERGE_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final long DEFAULT_SYNC_DELAY = 30L;
    public static final int DEFAULT_THREADS = 3;
    public static final int MINIMUM_COMMAND_SIZE = 4000;
    public static final long MINIMUM_FETCH_TIMEOUT = TimeUnit.MINUTES.toSeconds(2L);
    public static final long MINIMUM_MERGE_TIMEOUT = TimeUnit.MINUTES.toSeconds(2L);
    public static final String PROP_PREFIX = "plugin.bitbucket-repository-ref-sync.";
    public static final String PROP_ENVIRONMENT_COMMAND_SIZE = "environment.commandsize";
    public static final String PROP_FETCH_TIMEOUT = "plugin.bitbucket-repository-ref-sync.fetch.timeout";
    public static final String PROP_MERGE_TIMEOUT = "plugin.bitbucket-repository-ref-sync.merge.timeout";
    public static final String PROP_SYNC_DELAY = "plugin.bitbucket-repository-ref-sync.sync.delay";
    public static final String PROP_THREADS = "plugin.bitbucket-repository-ref-sync.threads";
    public static final String SCM_PROP_USE_ALTERNATES = "forks.usealternates";
    private final GitScmConfig config;
    private final long fetchTimeout;
    private final long mergeTimeout;
    private final boolean possible;
    private final long syncDelay;
    private final int threads;

    public DefaultRefSyncConfig(GitScmConfig config, ApplicationPropertiesService propertiesService) {
        this.config = config;
        this.fetchTimeout = Math.max(propertiesService.getPluginProperty(PROP_FETCH_TIMEOUT, DEFAULT_FETCH_TIMEOUT), MINIMUM_FETCH_TIMEOUT);
        this.mergeTimeout = Math.max(propertiesService.getPluginProperty(PROP_MERGE_TIMEOUT, DEFAULT_MERGE_TIMEOUT), MINIMUM_MERGE_TIMEOUT);
        this.syncDelay = Math.max(propertiesService.getPluginProperty(PROP_SYNC_DELAY, 30L), 0L);
        this.threads = Math.max(propertiesService.getPluginProperty(PROP_THREADS, 3), 1);
        this.possible = config.getProperty(SCM_PROP_USE_ALTERNATES, true);
    }

    @Override
    public int getCommandSize() {
        return Math.max(this.config.getProperty(PROP_ENVIRONMENT_COMMAND_SIZE, 32000), 4000);
    }

    @Override
    public long getFetchTimeout() {
        return this.fetchTimeout;
    }

    @Override
    public long getMergeTimeout() {
        return this.mergeTimeout;
    }

    @Override
    @Nonnull
    public String getRelativePath(@Nonnull Repository repository, @Nonnull Repository relativeTo) {
        return this.config.getRelativePath(repository, relativeTo);
    }

    @Override
    public long getSyncDelay() {
        return this.syncDelay;
    }

    @Override
    public int getThreadCount() {
        return this.threads;
    }

    @Override
    public boolean isPossible() {
        return this.possible;
    }
}

