/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.sync;

import com.atlassian.bitbucket.event.repository.AbstractRepositoryRefsChangedEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;

@AsynchronousPreferred
public class RefsSynchronizedEvent
extends AbstractRepositoryRefsChangedEvent {
    private final Collection<RejectedRef> rejectedRefs;
    private final Repository upstream;
    private final Collection<RefChange> upstreamChanges;

    public RefsSynchronizedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Repository upstream, @Nonnull RefChange refChange) {
        this(source, repository, Collections.singleton(refChange), Collections.emptySet(), upstream, Collections.emptySet());
    }

    public RefsSynchronizedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges, @Nonnull Iterable<RejectedRef> rejectedRefs, @Nonnull Repository upstream, @Nonnull Iterable<RefChange> upstreamChanges) {
        super(source, repository, refChanges);
        this.rejectedRefs = ImmutableList.copyOf(Objects.requireNonNull(rejectedRefs, "rejectedRefs"));
        this.upstream = Objects.requireNonNull(upstream, "upstream");
        this.upstreamChanges = ImmutableList.copyOf(Objects.requireNonNull(upstreamChanges, "upstreamChanges"));
    }

    @Nonnull
    public Collection<RejectedRef> getRejectedRefs() {
        return this.rejectedRefs;
    }

    @Nonnull
    public Repository getUpstream() {
        return this.upstream;
    }

    @Nonnull
    public Collection<RefChange> getUpstreamChanges() {
        return this.upstreamChanges;
    }
}

