/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import java.util.Properties;
import org.springframework.util.PropertyPlaceholderHelper;

public class PlaceholderResolvingProperties
extends Properties {
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
    private final PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver;

    public PlaceholderResolvingProperties(final Properties defaults) {
        super(defaults);
        this.placeholderResolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String key) {
                return defaults.getProperty(key);
            }
        };
    }

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (value != null) {
            value = this.propertyPlaceholderHelper.replacePlaceholders(value, this.placeholderResolver);
        }
        return value;
    }
}

