/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.atlassian.stash.internal.spring.TransactionalState;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class DefaultTransactionalState<K, V>
implements TransactionalState<K, V> {
    private final Object namespace;

    DefaultTransactionalState(Object namespace) {
        this.namespace = namespace;
    }

    @Override
    public V get(K key) {
        Object resource = TransactionSynchronizationManager.getResource((Object)this.namespace);
        if (resource instanceof Map) {
            Map txMap = (Map)resource;
            return txMap.get(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Map<K, V> txMap;
        Preconditions.checkState((boolean)TransactionSynchronizationManager.isSynchronizationActive(), (Object)"There is no active transaction");
        Object resource = TransactionSynchronizationManager.getResource((Object)this.namespace);
        if (resource == null) {
            txMap = new HashMap();
            TransactionSynchronizationManager.bindResource((Object)this.namespace, txMap);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    DefaultTransactionalState.this.clear();
                }
            });
        } else if (resource instanceof Map) {
            txMap = (Map)resource;
        } else {
            throw new IllegalStateException("The transactional resource is not a map! (" + resource.getClass().getName() + ")");
        }
        return txMap.put(key, value);
    }

    @Override
    public void clear() {
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.namespace);
    }
}

