/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.atlassian.stash.internal.spring.DefaultTransactionalState;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.atlassian.stash.internal.spring.TransactionalState;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component(value="transactionSynchronizer")
public class DefaultTransactionSynchronizer
implements TransactionSynchronizer {
    @Override
    @Nonnull
    public <K, V> TransactionalState<K, V> getTransactionState(@Nonnull Object namespace) {
        return new DefaultTransactionalState(Preconditions.checkNotNull((Object)namespace, (Object)"namespace"));
    }

    @Override
    public boolean isAvailable() {
        return TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isSynchronizationActive();
    }

    @Override
    public boolean register(@Nonnull TransactionSynchronization synchronization) {
        if (this.isAvailable()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)((TransactionSynchronization)Preconditions.checkNotNull((Object)synchronization, (Object)"synchronization")));
            return true;
        }
        return false;
    }
}

