/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.Product;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.plugin.ClusteredPluginPersistentStateStore;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class PluginUpgradeHelper {
    private static final String BUNDLED_PLUGINS = "application-provided-plugins.txt";
    private static final String OBSOLETE_PLUGINS = "application-obsolete-plugins.txt";
    private static final Logger log = LoggerFactory.getLogger(PluginUpgradeHelper.class);
    private final BuildInfo buildInfo;
    private final ApplicationSettings settings;
    private final ClusteredPluginPersistentStateStore store;
    private boolean anyPluginDisabled;
    private volatile Function<PluginPersistentState, PluginPersistentState> wrapper;

    @Autowired
    public PluginUpgradeHelper(BuildInfo buildInfo, ApplicationSettings settings, ClusteredPluginPersistentStateStore store) {
        this.buildInfo = buildInfo;
        this.settings = settings;
        this.store = store;
        this.wrapper = Function.identity();
    }

    public void clear() {
        this.anyPluginDisabled = false;
    }

    public boolean isAnyPluginDisabled() {
        return this.anyPluginDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withUpgrade(Runnable runnable) {
        Path upgradeMarker = this.settings.getConfigDir().toPath().resolve("upgrades").resolve("disable-plugins");
        if (Files.exists(upgradeMarker, new LinkOption[0])) {
            runnable.run();
            return;
        }
        Set<String> bundledPlugins = PluginUpgradeHelper.read(BUNDLED_PLUGINS);
        Set<String> removedPlugins = PluginUpgradeHelper.read(OBSOLETE_PLUGINS);
        UpgradeState state = new UpgradeState(bundledPlugins, removedPlugins);
        this.wrapper = delegate -> new UpgradePluginPersistentState((PluginPersistentState)delegate, state);
        try {
            runnable.run();
        }
        finally {
            this.wrapper = Function.identity();
        }
        boolean marked = this.createMarker(upgradeMarker);
        if (state.isUpdated()) {
            this.anyPluginDisabled = true;
            PluginPersistentState upgradedState = state.applyTo(this.store.load());
            if (marked) {
                this.store.save(upgradedState);
            } else {
                try (ClusteredPluginPersistentStateStore.ReadOnlyMarker ignored = this.store.markReadOnly();){
                    this.store.save(upgradedState);
                }
            }
        }
    }

    @Nonnull
    public PluginPersistentState wrap(@Nonnull PluginPersistentState state) {
        return this.wrapper.apply(state);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static Set<String> read(@Nonnull String name) {
        ClassPathResource resource = new ClassPathResource(name, PluginMetadataManager.class);
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.US_ASCII);){
            Set<String> set = CharStreams.readLines((Readable)reader).stream().filter(line -> !line.startsWith("#")).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createMarker(@Nonnull Path upgradeMarker) {
        try (BufferedWriter writer = Files.newBufferedWriter(upgradeMarker, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            writer.write(this.buildInfo.getBuildNumber());
            boolean bl = true;
            return bl;
        }
        catch (FileAlreadyExistsException e) {
            log.debug("Disabled plugins have already been persisted");
            return false;
        }
        catch (IOException e) {
            log.warn("Plugin upgrade could not be persisted. User-installed plugins will be disabled again the next time {} starts.", (Object)Product.NAME, (Object)e);
        }
        return false;
    }

    private static class UpgradeState {
        private final Set<String> bundledPlugins;
        private final Set<String> disabledPlugins;
        private final Set<String> removedPlugins;

        public UpgradeState(Set<String> bundledPlugins, Set<String> removedPlugins) {
            this.bundledPlugins = bundledPlugins;
            this.removedPlugins = removedPlugins;
            this.disabledPlugins = new HashSet<String>();
        }

        @Nonnull
        public PluginPersistentState applyTo(@Nonnull PluginPersistentState state) {
            log.info("Disabled {} plugins due to {} upgrade", (Object)this.disabledPlugins.size(), (Object)Product.NAME);
            return PluginPersistentState.Builder.create((PluginPersistentState)state).addState(Maps.asMap(this.disabledPlugins, pluginKey -> false)).toState();
        }

        public void disable(@Nonnull String pluginKey) {
            log.warn("Disabled {}", (Object)pluginKey);
            this.disabledPlugins.add(pluginKey);
        }

        public boolean isBundled(@Nonnull String pluginKey) {
            return this.bundledPlugins.contains(pluginKey);
        }

        public boolean isRemoved(@Nonnull String pluginKey) {
            return this.removedPlugins.contains(pluginKey);
        }

        public boolean isUpdated() {
            return !this.disabledPlugins.isEmpty();
        }
    }

    private class UpgradePluginPersistentState
    implements PluginPersistentState {
        private final PluginPersistentState delegate;
        private final UpgradeState state;

        public UpgradePluginPersistentState(PluginPersistentState delegate, UpgradeState state) {
            this.delegate = delegate;
            this.state = state;
        }

        public Map<String, Boolean> getMap() {
            return this.delegate.getMap();
        }

        public boolean isEnabled(Plugin plugin) {
            String key = plugin.getKey();
            if (this.state.isBundled(key)) {
                return this.delegate.isEnabled(plugin);
            }
            this.state.disable(key);
            return false;
        }

        public boolean isEnabled(ModuleDescriptor<?> pluginModule) {
            return this.delegate.isEnabled(pluginModule);
        }

        public Map<String, Boolean> getPluginStateMap(Plugin plugin) {
            return this.delegate.getPluginStateMap(plugin);
        }

        public PluginRestartState getPluginRestartState(String pluginKey) {
            return this.state.isRemoved(pluginKey) ? PluginRestartState.REMOVE : this.delegate.getPluginRestartState(pluginKey);
        }
    }
}

