/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.spi;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.spi.HostContextAccessor;
import com.atlassian.stash.internal.plugin.InternalHostContainer;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=HostContextAccessor.class)
@Component(value="hostContextAccessor")
public class HostContextAccessorImpl
implements HostContextAccessor {
    private final InternalHostContainer hostContainer;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public HostContextAccessorImpl(InternalHostContainer hostContainer, PlatformTransactionManager transactionManager) {
        this.hostContainer = hostContainer;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public <T> Map<String, T> getComponentsOfType(Class<T> tClass) {
        return this.hostContainer.getComponentsOfType(tClass);
    }

    @Transactional
    public <T> T doInTransaction(HostContextAccessor.HostTransactionCallback<T> callback) {
        if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            return (T)this.transactionTemplate.execute(status -> callback.doInTransaction());
        }
        return (T)callback.doInTransaction();
    }
}

