/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.process;

import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.utils.process.ConfigurableExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ExternalProcessConfigurer;
import com.atlassian.utils.process.ExternalProcessFactory;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtendedExternalProcessFactory
extends ConfigurableExternalProcessFactory {
    private final ApplicationSettings settings;

    public ExtendedExternalProcessFactory(ExecutorService executorService, ApplicationSettings settings) {
        super(executorService);
        this.settings = settings;
    }

    @PostConstruct
    public void initialise() {
        ExternalProcessBuilder.setExternalProcessFactory((ExternalProcessFactory)this);
        if (SystemUtils.IS_OS_WINDOWS) {
            System.setProperty("winp.folder.preferred", new File(this.settings.getNativeDir(), "truncated").getAbsolutePath());
        }
    }

    @Autowired(required=false)
    public void setConfigurers(@Nonnull List<ExternalProcessConfigurer> configurers) {
        super.setConfigurers(configurers);
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
    }
}

