/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.plugin.web.fragments.AbstractClientWebFragmentModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebInterfaceManager;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebItemModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebPanelModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebSectionModuleDescriptor;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultClientWebInterfaceManager
implements ClientWebInterfaceManager {
    private LoadingCache<String, List<ClientWebSectionModuleDescriptor>> sections;
    private LoadingCache<String, List<ClientWebItemModuleDescriptor>> items;
    private LoadingCache<String, List<ClientWebPanelModuleDescriptor>> panels;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public DefaultClientWebInterfaceManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.sections = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ClientWebSectionModuleDescriptor>>(){

            public List<ClientWebSectionModuleDescriptor> load(String location) throws Exception {
                return DefaultClientWebInterfaceManager.this.getFragments(location, ClientWebSectionModuleDescriptor.class);
            }
        });
        this.items = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ClientWebItemModuleDescriptor>>(){

            public List<ClientWebItemModuleDescriptor> load(String location) throws Exception {
                return DefaultClientWebInterfaceManager.this.getFragments(location, ClientWebItemModuleDescriptor.class);
            }
        });
        this.panels = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ClientWebPanelModuleDescriptor>>(){

            public List<ClientWebPanelModuleDescriptor> load(String location) throws Exception {
                return DefaultClientWebInterfaceManager.this.getFragments(location, ClientWebPanelModuleDescriptor.class);
            }
        });
    }

    @Override
    public List<ClientWebSectionModuleDescriptor> getSections(String location) {
        return (List)this.sections.getUnchecked((Object)location);
    }

    @Override
    public List<ClientWebItemModuleDescriptor> getItems(String location) {
        return (List)this.items.getUnchecked((Object)location);
    }

    @Override
    public List<ClientWebPanelModuleDescriptor> getPanels(String location) {
        return (List)this.panels.getUnchecked((Object)location);
    }

    private <T extends AbstractClientWebFragmentModuleDescriptor> List<T> getFragments(String location, Class<T> clazz) {
        if (location == null) {
            return Collections.emptyList();
        }
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(clazz).stream().filter(moduleDescriptor -> location.equalsIgnoreCase(moduleDescriptor.getLocation())).collect(Collectors.toList());
    }

    @Override
    public void refresh() {
        this.sections.invalidateAll();
        this.items.invalidateAll();
        this.panels.invalidateAll();
    }
}

