/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.stash.internal.plugin.web.fragments.AbstractClientWebFragmentModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentFieldType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebInterfaceManager;
import org.dom4j.Element;

public class ClientWebItemModuleDescriptor
extends AbstractClientWebFragmentModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "client-web-item".intern();
    private String location;

    public ClientWebItemModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer, ClientWebInterfaceManager clientWebInterfaceManager, ConditionElementParser.ConditionFactory conditionFactory, WebFragmentHelper webFragmentHelper) {
        super(moduleFactory, hostContainer, clientWebInterfaceManager, conditionFactory, webFragmentHelper);
    }

    @Override
    protected ClientWebFragmentType getFragmentType() {
        return ClientWebFragmentType.ITEM;
    }

    @Override
    protected void addFields(Element container, Element originalElement) {
        Element icon;
        Element label;
        this.copyElement("tooltip", originalElement, container, ClientWebFragmentFieldType.TEXT);
        this.copyElement("styleClass", originalElement, container, ClientWebFragmentFieldType.TEXT);
        this.copyElement("description", originalElement, container, ClientWebFragmentFieldType.TEXT);
        this.location = originalElement.attributeValue("section");
        if (this.location == null) {
            throw new PluginParseException("section is a required attribute for client web items.");
        }
        this.addStringElement(container, "location", this.location);
        Element link = originalElement.element("link");
        if (link != null) {
            String linkId = link.attributeValue("linkId");
            if (linkId != null) {
                this.addTextElement(container, "linkId", linkId);
            }
            this.addElement(container, "url", this.getType(link, ClientWebFragmentFieldType.TEXT), link.getText(), link.attributeValue("key"));
        }
        if ((label = originalElement.element("label")) != null) {
            this.addElement(container, "linkText", this.getType(label, ClientWebFragmentFieldType.TEXT), label.getText(), label.attributeValue("key"));
        }
        if ((icon = originalElement.element("icon")) != null) {
            String width;
            String height = icon.attributeValue("height");
            if (height != null) {
                this.addNumberElement(container, "iconHeight", Float.parseFloat(height));
            }
            if ((width = icon.attributeValue("width")) != null) {
                this.addNumberElement(container, "iconWidth", Float.parseFloat(width));
            }
            Element iconLink = icon.element("link");
            this.addElement(container, "iconUrl", this.getType(iconLink, ClientWebFragmentFieldType.TEXT), iconLink.getText(), iconLink.attributeValue("key"));
        }
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

