/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.hook.repository.AsyncPostReceiveRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreReceiveRepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookImplementor;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeRequestCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.setting.RepositorySettingsValidator;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.stash.internal.plugin.ValidatorModuleDescriptor;
import com.atlassian.stash.internal.plugin.WebResourceGenerationHelper;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebInterfaceManager;
import com.atlassian.stash.internal.plugin.web.fragments.ConfigurationFormModuleDescriptor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dom4j.Element;
import org.osgi.framework.ServiceRegistration;

public class RepositoryHookModuleDescriptor
extends AbstractModuleDescriptor<RepositoryHookImplementor>
implements ValidatorModuleDescriptor<RepositoryHookImplementor> {
    public static final String XML_ELEMENT_NAME = "repository-hook";
    private final ClientWebInterfaceManager clientWebInterfaceManager;
    private final ConditionElementParser.ConditionFactory conditionFactory;
    private final HostContainer hostContainer;
    private final I18nService i18nService;
    private final WebResourceGenerationHelper webResourceGenerationHelper;
    private final WebFragmentHelper webFragmentHelper;
    private String iconPath;
    private ConfigurationFormModuleDescriptor configuredFormModuleDescriptor;
    private ServiceRegistration configurationFormRegistration;
    private RepositoryHookType type;
    private RepositoryHookImplementor module;
    private String validatorClassName;
    private RepositorySettingsValidator validator;

    public RepositoryHookModuleDescriptor(ModuleFactory moduleFactory, ClientWebInterfaceManager clientWebInterfaceManager, ConditionElementParser.ConditionFactory conditionFactory, WebFragmentHelper webFragmentHelper, HostContainer hostContainer, I18nService i18nService, WebResourceGenerationHelper webResourceGenerationHelper) {
        super(moduleFactory);
        this.clientWebInterfaceManager = clientWebInterfaceManager;
        this.conditionFactory = conditionFactory;
        this.i18nService = i18nService;
        this.hostContainer = hostContainer;
        this.webResourceGenerationHelper = webResourceGenerationHelper;
        this.webFragmentHelper = webFragmentHelper;
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@class").withError("The class for the hook implementation is required"), ValidationPattern.test((String)"@name").withError("The name is required")});
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        Element validatorElement;
        Element configElement;
        super.init(plugin, element);
        Element iconElement = element.element("icon");
        if (iconElement != null) {
            this.iconPath = iconElement.getTextTrim();
        }
        if ((configElement = element.element("config-form")) != null) {
            if (!(plugin instanceof OsgiPlugin)) {
                throw new PluginParseException("repository-hook can only be used in OSGi plugins");
            }
            configElement = this.processConfig(element, configElement);
            this.configuredFormModuleDescriptor = new ConfigurationFormModuleDescriptor(this.moduleFactory, this.hostContainer, this.clientWebInterfaceManager, this.conditionFactory, this.webFragmentHelper, this.webResourceGenerationHelper);
            this.configuredFormModuleDescriptor.init(plugin, configElement);
        }
        if ((validatorElement = element.element("validator")) != null) {
            this.validatorClassName = validatorElement.getStringValue();
        }
    }

    private Element processConfig(Element moduleElement, Element configElement) {
        configElement = configElement.createCopy();
        configElement.setParent(moduleElement.getParent());
        configElement.addAttribute("key", this.getKey() + "-config-form");
        return configElement;
    }

    public void enabled() {
        super.enabled();
        Class<PreReceiveRepositoryHook> implemented = null;
        if (PreReceiveRepositoryHook.class.isAssignableFrom(this.moduleClass)) {
            implemented = PreReceiveRepositoryHook.class;
            this.type = RepositoryHookType.PRE_RECEIVE;
        } else if (RepositoryMergeRequestCheck.class.isAssignableFrom(this.moduleClass)) {
            implemented = RepositoryMergeRequestCheck.class;
            this.type = RepositoryHookType.PRE_RECEIVE;
        }
        if (AsyncPostReceiveRepositoryHook.class.isAssignableFrom(this.moduleClass)) {
            if (implemented != null) {
                throw new PluginParseException(String.format("Hook must not implement both %s and %s", implemented.getSimpleName(), AsyncPostReceiveRepositoryHook.class));
            }
            implemented = AsyncPostReceiveRepositoryHook.class;
            this.type = RepositoryHookType.POST_RECEIVE;
        }
        if (implemented == null) {
            throw new PluginParseException(String.format("Hook must implement %s and/or %s or %s.", PreReceiveRepositoryHook.class.getSimpleName(), RepositoryMergeRequestCheck.class.getSimpleName(), AsyncPostReceiveRepositoryHook.class.getSimpleName()));
        }
        if (this.configuredFormModuleDescriptor != null) {
            this.configurationFormRegistration = ((OsgiPlugin)this.getPlugin()).getBundle().getBundleContext().registerService(ModuleDescriptor.class.getName(), (Object)this.configuredFormModuleDescriptor, null);
        }
        this.module = (RepositoryHookImplementor)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        this.validator = this.createValidator();
    }

    private RepositorySettingsValidator createValidator() {
        if (this.validatorClassName != null) {
            try {
                Class validatorClass = this.plugin.loadClass(this.validatorClassName, this.getClass());
                return (RepositorySettingsValidator)((OsgiPlugin)this.getPlugin()).getContainerAccessor().createBean(validatorClass);
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException(String.format("Hook validator class '%s' not found", this.validatorClassName), (Throwable)e);
            }
        }
        if (RepositorySettingsValidator.class.isAssignableFrom(this.moduleClass)) {
            return (RepositorySettingsValidator)this.getModule();
        }
        return null;
    }

    public void disabled() {
        this.type = null;
        if (this.configurationFormRegistration != null) {
            this.configurationFormRegistration.unregister();
            this.configurationFormRegistration = null;
        }
        this.module = null;
        this.validator = null;
        super.disabled();
    }

    public RepositoryHookImplementor getModule() {
        return this.module;
    }

    public String getI18nName() {
        return this.getI18nNameKey() != null ? this.i18nService.getText(this.getI18nNameKey(), this.getName(), new Object[0]) : this.getName();
    }

    @Nullable
    public String getI18nDescription() {
        return this.getDescriptionKey() != null ? this.i18nService.getText(this.getDescriptionKey(), this.getDescription(), new Object[0]) : this.getDescription();
    }

    public String getIconPath() {
        return this.iconPath;
    }

    @Nullable
    public String getConfigFormKey() {
        return this.configuredFormModuleDescriptor != null ? this.configuredFormModuleDescriptor.getCompleteKey() : null;
    }

    public RepositoryHookType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public RepositorySettingsValidator getValidator() {
        return this.validator;
    }
}

