/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreprocessedWebResourceModuleDescriptor
extends WebResourceModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(PreprocessedWebResourceModuleDescriptor.class);
    private Element originalElement;
    private Element derivedElement;
    private boolean enabledPreviously = false;

    public PreprocessedWebResourceModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer) {
        super(moduleFactory, hostContainer);
    }

    public Element getElement() {
        return this.derivedElement;
    }

    public Element getOriginalElement() {
        return this.originalElement;
    }

    public Void getModule() {
        return null;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        this.plugin = plugin;
        this.originalElement = element;
        this.derivedElement = this.generateElement(element);
        this.derivedElement.setParent(element.getParent());
        if (log.isTraceEnabled()) {
            String key = (String)MoreObjects.firstNonNull((Object)element.attributeValue("key"), (Object)"<unknown>");
            StringBuilderWriter writer = new StringBuilderWriter();
            PrintWriter printWriter = new PrintWriter((Writer)writer);
            printWriter.format("Transformed %s:%s", plugin.getKey(), key);
            PreprocessedWebResourceModuleDescriptor.writeXml(this.originalElement, printWriter);
            PreprocessedWebResourceModuleDescriptor.writeXml(this.derivedElement, printWriter);
            printWriter.close();
            log.trace(writer.toString());
        }
        super.init(plugin, this.derivedElement);
    }

    public void enabled() {
        super.enabled();
        if ((!this.enabledPreviously || DevModeUtils.isEnabled()) && this.postEnableProcessing()) {
            this.resources = Resources.fromXml((Element)this.getElement());
        }
        this.enabledPreviously = true;
    }

    protected boolean postEnableProcessing() {
        return false;
    }

    protected Element generateElement(Element originalElement) {
        return originalElement.createCopy();
    }

    private static void writeXml(Element element, PrintWriter writer) {
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(element);
            xmlWriter.flush();
        }
        catch (IOException e) {
            writer.print("Unable to convert Element into XML: ");
            writer.println(e.getMessage());
        }
    }
}

