/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.google.common.base.MoreObjects;
import java.util.Locale;
import org.dom4j.Element;

public class LanguageModuleDescriptor
extends AbstractModuleDescriptor<Locale> {
    public static final String XML_ELEMENT_NAME = "language".intern();
    private volatile Locale locale;

    public LanguageModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public Locale getModule() {
        return this.locale;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String language = element.attributeValue("language");
        String country = element.attributeValue("country");
        String variant = element.attributeValue("variant");
        this.locale = new Locale(language, (String)MoreObjects.firstNonNull((Object)country, (Object)""), (String)MoreObjects.firstNonNull((Object)variant, (Object)""));
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@language").withError("The language attribute is required")});
    }
}

