/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.stash.internal.plugin.PluginControllerOperation;
import com.atlassian.stash.internal.plugin.PluginOperationType;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredPluginController
implements PluginController {
    private static final MemberSelector NOT_LOCAL = new MemberSelector(){

        public boolean select(Member member) {
            return !member.localMember();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ClusteredPluginController.class);
    private final ClusterService clusterService;
    private final PluginController delegate;
    private final IExecutorService executorService;

    public ClusteredPluginController(ClusterService clusterService, PluginController delegate, IExecutorService executorService) {
        this.clusterService = clusterService;
        this.delegate = delegate;
        this.executorService = executorService;
    }

    public void enablePlugin(String key) {
        this.delegate.enablePlugin(key);
        this.submitToOtherMembers(key, PluginOperationType.ENABLE_PLUGIN);
    }

    public void enablePlugins(String ... keys) {
        this.delegate.enablePlugins(keys);
        for (String key : keys) {
            this.submitToOtherMembers(key, PluginOperationType.ENABLE_PLUGIN);
        }
    }

    public void disablePlugin(String key) {
        this.delegate.disablePlugin(key);
        this.submitToOtherMembers(key, PluginOperationType.DISABLE_PLUGIN);
    }

    public void disablePluginWithoutPersisting(String key) {
        this.delegate.disablePlugin(key);
        this.submitToOtherMembers(key, PluginOperationType.DISABLE_PLUGIN);
    }

    public void enablePluginModule(String completeKey) {
        this.delegate.enablePluginModule(completeKey);
        this.submitToOtherMembers(completeKey, PluginOperationType.ENABLE_MODULE);
    }

    public void disablePluginModule(String completeKey) {
        this.delegate.disablePluginModule(completeKey);
        this.submitToOtherMembers(completeKey, PluginOperationType.DISABLE_MODULE);
    }

    public String installPlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        String pluginKey = this.delegate.installPlugin(pluginArtifact);
        this.submitToOtherMembers(null, PluginOperationType.SCAN_FOR_PLUGINS);
        return pluginKey;
    }

    public Set<String> installPlugins(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        Set pluginKeys = this.delegate.installPlugins(pluginArtifacts);
        this.submitToOtherMembers(null, PluginOperationType.SCAN_FOR_PLUGINS);
        return pluginKeys;
    }

    public void uninstall(Plugin plugin) throws PluginException {
        this.delegate.uninstall(plugin);
        this.submitToOtherMembers(plugin.getKey(), PluginOperationType.UNINSTALL_PLUGIN);
    }

    public void revertRestartRequiredChange(String pluginKey) throws PluginException {
        this.delegate.revertRestartRequiredChange(pluginKey);
        this.submitToOtherMembers(pluginKey, PluginOperationType.REVERT_RESTART_REQUIRED);
    }

    public int scanForNewPlugins() throws PluginParseException {
        int count = this.delegate.scanForNewPlugins();
        this.submitToOtherMembers(null, PluginOperationType.SCAN_FOR_PLUGINS);
        return count;
    }

    public ModuleDescriptor<?> addDynamicModule(Plugin plugin, Element element) {
        log.error("Unable to add Dynamic Module for plugin key [{}] because the functionality is not currently supported", (Object)plugin.getKey());
        throw new UnsupportedOperationException("The Clustered Plugin Controller does not support Dynamic Modules");
    }

    public void removeDynamicModule(Plugin plugin, ModuleDescriptor<?> moduleDescriptor) {
        log.error("Unable to remove Dynamic Module for plugin key [{}] because the functionality is not currently supported", (Object)plugin.getKey());
        throw new UnsupportedOperationException("The Clustered Plugin Controller does not support Dynamic Modules");
    }

    private void submitToOtherMembers(final String key, final PluginOperationType type) {
        if (this.clusterService.isClustered()) {
            try {
                this.executorService.submitToMembers((Runnable)new PluginControllerOperation(key, type), NOT_LOCAL, new MultiExecutionCallback(){

                    public void onResponse(Member member, Object value) {
                        if (value instanceof Throwable) {
                            log.warn("Failed to perform {} for key {} on node (id={}, address={})", new Object[]{type, key, member.getUuid(), member.getSocketAddress(), value});
                        } else {
                            log.debug("{} performed on for key {} on node (id={}, address={})", new Object[]{type, key, member.getUuid(), member.getSocketAddress()});
                        }
                    }

                    public void onComplete(Map<Member, Object> values) {
                    }
                });
            }
            catch (RejectedExecutionException e) {
                log.warn("Failed to perform {} for key {} on other nodes", new Object[]{type, key, e});
            }
        }
    }
}

