/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mode;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ApplicationModeCondition
implements Condition {
    private static final Map<ApplicationMode, String> modeMap = Maps.newHashMap();

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ApplicationMode mode = ApplicationMode.fromId((String)context.getEnvironment().getProperty("application.mode")).orElse(ApplicationMode.DEFAULT);
        String annotationName = modeMap.get(mode);
        return annotationName != null && metadata.isAnnotated(annotationName);
    }

    static {
        modeMap.put(ApplicationMode.DEFAULT, DefaultApplicationMode.class.getName());
        modeMap.put(ApplicationMode.MIRROR, MirrorApplicationMode.class.getName());
    }
}

