/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.help;

import com.atlassian.bitbucket.help.HelpPathService;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHelpPathService
implements HelpPathService {
    protected abstract String getProperty(String var1);

    public String getPageAlt(String topicKey) {
        return topicKey == null ? null : this.getProperty(topicKey + ".alt");
    }

    public String getPageKey(String topicKey) {
        return topicKey == null ? null : this.getProperty(topicKey);
    }

    public String getPageTitle(String topicKey) {
        return topicKey == null ? null : this.getProperty(topicKey + ".title");
    }

    public String getPageUrl(String topicKey) {
        String helpPrefix = this.getPrefix(topicKey);
        String helpPageKey = this.getPageKey(topicKey);
        if (helpPageKey != null && helpPrefix != null) {
            return String.format("%s/%s", helpPrefix, helpPageKey);
        }
        return null;
    }

    public String getPrefix() {
        return this.getProperty("bitbucket.help.prefix");
    }

    private String getPrefix(String topicKey) {
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.kb.")) {
            return this.getProperty("bitbucket.kb.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.wac.")) {
            return this.getProperty("bitbucket.wac.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.go.")) {
            return this.getProperty("bitbucket.go.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.dac.")) {
            return this.getProperty("bitbucket.dac.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"embedded.crowd.support.")) {
            return this.getProperty("embedded.crowd.support.prefix");
        }
        return this.getPrefix();
    }
}

