/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.stash.internal.util.StackException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventThreadPoolExecutor
extends ThreadPoolExecutor
implements RejectedExecutionHandler {
    private static final Logger log = LoggerFactory.getLogger(EventThreadPoolExecutor.class);
    private final Map<Runnable, Thread> activeThreads;
    private final RejectedExecutionHandler delegate;
    private final long rejectionCooldown;
    private volatile long lastRejection;

    public EventThreadPoolExecutor(EventThreadPoolConfiguration configuration, ThreadFactory threadFactory, int maxQueueSize, long rejectionCooldown) {
        super(configuration.getCorePoolSize(), configuration.getMaximumPoolSize(), configuration.getKeepAliveTime(), configuration.getTimeUnit(), new LinkedBlockingQueue<Runnable>(maxQueueSize), threadFactory);
        this.rejectionCooldown = TimeUnit.MINUTES.toNanos(rejectionCooldown);
        this.activeThreads = new ConcurrentHashMap<Runnable, Thread>(configuration.getMaximumPoolSize(), 1.0f);
        this.delegate = this.getRejectedExecutionHandler();
        this.setRejectedExecutionHandler(this);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        this.maybeLogThreads();
        this.delegate.rejectedExecution(r, executor);
    }

    @Override
    protected void afterExecute(Runnable task, Throwable thrown) {
        this.activeThreads.remove(task);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable task) {
        this.activeThreads.put(task, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLogThreads() {
        long check = System.nanoTime();
        if (check - this.lastRejection > this.rejectionCooldown) {
            Map<Runnable, Thread> map = this.activeThreads;
            synchronized (map) {
                if (check - this.lastRejection > this.rejectionCooldown) {
                    this.lastRejection = System.nanoTime();
                    log.warn("The event queue is full. Stacks for the processing threads follow:");
                    for (Thread thread : this.activeThreads.values()) {
                        log.warn("Stack trace for {}", (Object)thread.getName(), (Object)new StackException(thread));
                    }
                }
            }
        }
    }
}

