/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.stash.internal.concurrent.CompositeTransferableState;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=ThreadLocalContextManager.class)
@Component(value="threadLocalContextManager")
public class DefaultThreadLocalContextManager
implements ApplicationListener<ContextRefreshedEvent>,
ThreadLocalContextManager {
    private final Set<StatefulService> statefulServices = new CopyOnWriteArraySet<StatefulService>();
    private final ThreadLocal<CompositeTransferableState> threadState = new ThreadLocal();

    public void clearThreadLocalContext() {
        CompositeTransferableState currentThreadState = this.threadState.get();
        if (currentThreadState != null) {
            currentThreadState.remove();
        }
        this.threadState.remove();
    }

    public CompositeTransferableState getThreadLocalContext() {
        return new CompositeTransferableState(Collections2.transform(this.statefulServices, StatefulService.TO_STATE));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.statefulServices.addAll(event.getApplicationContext().getBeansOfType(StatefulService.class).values());
    }

    public void setThreadLocalContext(Object context) {
        if (context instanceof CompositeTransferableState) {
            CompositeTransferableState currentThreadState = (CompositeTransferableState)context;
            this.threadState.set(currentThreadState);
            currentThreadState.apply();
        }
    }

    @VisibleForTesting
    public void setStatefulServices(StatefulService ... services) {
        this.statefulServices.addAll(Arrays.asList(services));
    }
}

