/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class ConfigurableThreadFactory
extends CustomizableThreadFactory {
    private ClassLoader classLoader;

    public Thread createThread(Runnable runnable) {
        Thread thread = super.createThread(runnable);
        thread.setContextClassLoader(this.classLoader);
        return thread;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        if ((threadNamePrefix = StringUtils.trimToNull((String)threadNamePrefix)) != null) {
            threadNamePrefix = threadNamePrefix + ":" + this.getDefaultThreadNamePrefix();
        }
        super.setThreadNamePrefix(threadNamePrefix);
    }

    protected String getDefaultThreadNamePrefix() {
        return "thread-";
    }
}

