/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.TransferableState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTransferableState
implements TransferableState {
    private static final Logger log = LoggerFactory.getLogger(CompositeTransferableState.class);
    private final List<TransferableState> states;

    public CompositeTransferableState(Iterable<TransferableState> states) {
        this.states = ImmutableList.copyOf(states);
    }

    @Override
    public void apply() {
        for (TransferableState state : this.states) {
            try {
                state.apply();
            }
            catch (Exception e) {
                log.warn("Failed to apply thread state", (Throwable)e);
            }
        }
    }

    @Override
    public void remove() {
        for (TransferableState state : this.states) {
            try {
                state.remove();
            }
            catch (Exception e) {
                log.warn("Failed to remove thread state", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    List<TransferableState> getStates() {
        return this.states;
    }
}

