/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.security.auth.trustedapps.filter.AuthenticationController;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrustedApplicationsAuthController
implements AuthenticationController {
    private final AuthenticationContext authenticationContext;
    private final LicenseService licenseService;

    @Autowired
    public TrustedApplicationsAuthController(AuthenticationContext authenticationContext, LicenseService licenseService) {
        this.authenticationContext = authenticationContext;
        this.licenseService = licenseService;
    }

    public boolean shouldAttemptAuthentication(HttpServletRequest request) {
        return !this.authenticationContext.isAuthenticated();
    }

    public boolean canLogin(Principal principal, HttpServletRequest request) {
        return this.licenseService.canLogin(principal);
    }
}

