/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.DataStoreException;
import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.comment.CommentOutOfDateException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component(value="exceptionRewriteAdvice")
public class ExceptionRewriteAdvice
implements ThrowsAdvice {
    private final I18nService i18nService;

    @Autowired
    public ExceptionRewriteAdvice(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public void afterThrowing(Method method, Object[] args, Object target, AccessDeniedException e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.accessdenied", new Object[0]);
        throw new AuthorisationException(message, (Throwable)e);
    }

    public void afterThrowing(Method method, Object[] args, Object target, HibernateException e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.datastorefail", new Object[0]);
        throw new DataStoreException(message, (Throwable)e);
    }

    public void afterThrowing(Method method, Object[] args, Object target, DataAccessException e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.datastorefail", new Object[0]);
        throw new DataStoreException(message, (Throwable)e);
    }

    public void afterThrowing(Method method, Object[] args, Object target, ObjectOptimisticLockingFailureException e) {
        if (this.isForEntity(e, InternalPullRequest.class)) {
            throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), (Throwable)e);
        }
        if (this.isForEntity(e, InternalComment.class)) {
            throw new CommentOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.comment.outofdate", new Object[0]), (Throwable)e);
        }
        throw new EntityOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.entity.outofdate", new Object[0]), (Throwable)e);
    }

    private boolean isForEntity(ObjectOptimisticLockingFailureException e, Class<?> clazz) {
        return e.getPersistentClassName() != null && clazz.getName().equals(e.getPersistentClassName());
    }

    private Repository findRepositoryWithinArgs(Object ... args) {
        for (Object arg : args) {
            if (!(arg instanceof Repository)) continue;
            return (Repository)arg;
        }
        return null;
    }
}

