/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.ao;

import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

@AvailableToPlugins(value=TransactionSynchronisationManager.class)
@Component(value="transactionSynchronisationManager")
public class SpringTransactionSynchronisationManager
implements TransactionSynchronisationManager {
    private final TransactionSynchronizer synchronizer;

    @Autowired
    public SpringTransactionSynchronisationManager(TransactionSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public boolean isActiveSynchronisedTransaction() {
        return this.synchronizer.isAvailable();
    }

    public boolean runOnRollBack(Runnable callback) {
        return this.maybeRegister(callback, 1);
    }

    public boolean runOnSuccessfulCommit(Runnable callback) {
        return this.maybeRegister(callback, 0);
    }

    private boolean maybeRegister(Runnable callback, int status) {
        return this.synchronizer.register((TransactionSynchronization)new RunnableTransactionSynchronization(callback, status));
    }

    private static class RunnableTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        private final Runnable runnable;
        private final int status;

        private RunnableTransactionSynchronization(Runnable runnable, int status) {
            this.runnable = runnable;
            this.status = status;
        }

        public void afterCompletion(int status) {
            if (this.status == status) {
                this.runnable.run();
            }
        }
    }
}

