/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.ao;

import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataSourceProvider
implements TenantAwareDataSourceProvider {
    private static final Map<String, DatabaseType> URL_PREFIX_TO_TYPE_MAP = ImmutableMap.builder().put((Object)"jdbc:h2:", (Object)DatabaseType.H2).put((Object)"jdbc:hsqldb:", (Object)DatabaseType.HSQL).put((Object)"jdbc:mysql:", (Object)DatabaseType.MYSQL).put((Object)"jdbc:oracle:", (Object)DatabaseType.ORACLE).put((Object)"jdbc:postgresql:", (Object)DatabaseType.POSTGRESQL).put((Object)"jdbc:jtds:sqlserver:", (Object)DatabaseType.MS_SQL).put((Object)"jdbc:sqlserver:", (Object)DatabaseType.MS_SQL).build();
    protected static final Logger log = LoggerFactory.getLogger(ApplicationDataSourceProvider.class);
    private final DataSource dataSource;
    private final DataSourceConfiguration dataSourceConfiguration;

    public ApplicationDataSourceProvider(DataSource dataSource, DataSourceConfiguration dataSourceConfiguration) {
        this.dataSource = dataSource;
        this.dataSourceConfiguration = dataSourceConfiguration;
    }

    @Nonnull
    public DataSource getDataSource(@Nonnull Tenant tenant) {
        Preconditions.checkNotNull((Object)tenant, (Object)"tenant");
        return this.dataSource;
    }

    @Nonnull
    public DatabaseType getDatabaseType(@Nonnull Tenant tenant) {
        Preconditions.checkNotNull((Object)tenant, (Object)"tenant");
        String url = this.dataSourceConfiguration.getUrl();
        if (url != null) {
            for (Map.Entry<String, DatabaseType> entry : URL_PREFIX_TO_TYPE_MAP.entrySet()) {
                if (!url.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        log.warn("Could not determine database type for {}", (Object)url);
        return DatabaseType.UNKNOWN;
    }

    public String getSchema(@Nonnull Tenant tenant) {
        Preconditions.checkNotNull((Object)tenant, (Object)"tenant");
        return null;
    }
}

