/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.process;

import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.utils.process.ExternalProcessConfigurer;
import com.atlassian.utils.process.ExternalProcessSettings;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultExternalProcessConfigurer
implements ExternalProcessConfigurer {
    private final ApplicationSettings settings;
    private long executionTimeout;
    private long idleTimeout;

    @Autowired
    public DefaultExternalProcessConfigurer(ApplicationSettings settings) {
        this.settings = settings;
    }

    public void configure(@Nonnull ExternalProcessSettings settings) {
        String tempDir = this.settings.getTempDir().getAbsolutePath();
        Map environment = settings.getEnvironment();
        DefaultExternalProcessConfigurer.putIfAbsent(environment, "TMPDIR", tempDir);
        if (SystemUtils.IS_OS_WINDOWS) {
            DefaultExternalProcessConfigurer.putIfAbsent(environment, "TEMP", tempDir);
            DefaultExternalProcessConfigurer.putIfAbsent(environment, "TMP", tempDir);
        }
        if (settings.getWorkingDirectory() == null) {
            settings.setWorkingDirectory(this.settings.getTempDir());
        }
        if (!settings.hasExecutionTimeout()) {
            settings.setExecutionTimeout(this.executionTimeout);
        }
        if (!settings.hasIdleTimeout()) {
            settings.setIdleTimeout(this.idleTimeout);
        }
    }

    @Value(value="${process.timeout.execution}")
    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = TimeUnit.SECONDS.toMillis(executionTimeout);
    }

    @Value(value="${process.timeout.idle}")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = TimeUnit.SECONDS.toMillis(idleTimeout);
    }

    private static void putIfAbsent(Map<String, String> map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

