/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.stash.internal.plugin.PreprocessedWebResourceModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.AbstractClientWebFragmentModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientPageDataHandler;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebInterfaceManager;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebItemModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebPanelModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebSectionModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class WebFragmentLocationModuleDescriptor
extends PreprocessedWebResourceModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "web-fragment-location".intern();
    private final ClientWebInterfaceManager clientWebInterfaceManager;
    private final ClientPageDataHandler clientPageDataHandler;
    private final WebResourceIntegration webResourceIntegration;
    private FragmentType fragmentType;
    private String location;

    public WebFragmentLocationModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer, ClientWebInterfaceManager clientWebInterfaceManager, ClientPageDataHandler clientPageDataHandler, WebResourceIntegration webResourceIntegration) {
        super(moduleFactory, hostContainer);
        this.clientWebInterfaceManager = clientWebInterfaceManager;
        this.clientPageDataHandler = clientPageDataHandler;
        this.webResourceIntegration = webResourceIntegration;
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@type").withError("type attribute is required for web-fragment-location. Must be one of: 'item', 'panel', or 'section'.")});
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@location").withError("location attribute is required for web-fragment-location")});
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        try {
            this.fragmentType = FragmentType.valueOf(element.attributeValue("type").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException("type attribute must be 'item', 'panel', 'section', or 'fragment'");
        }
        this.location = element.attributeValue("location");
    }

    @Override
    protected Element generateElement(Element originalElement) {
        Element generated = super.generateElement(originalElement);
        AbstractClientWebFragmentModuleDescriptor.addClientWebFragmentDependency(generated);
        return generated;
    }

    private Set<String> getWebPanelDependencies(Iterable<String> locations) {
        HashSet dependencies = Sets.newHashSet();
        for (String location : locations) {
            for (ClientWebPanelModuleDescriptor panel : this.clientWebInterfaceManager.getPanels(location)) {
                dependencies.add(panel.getCompleteKey());
            }
        }
        return dependencies;
    }

    private Set<String> getWebItemDependencies(Iterable<String> sections) {
        HashSet dependencies = Sets.newHashSet();
        for (String location : sections) {
            for (ClientWebItemModuleDescriptor item : this.clientWebInterfaceManager.getItems(location)) {
                dependencies.add(item.getCompleteKey());
            }
        }
        return dependencies;
    }

    private void requirePageData(Iterable<String> locations) {
        for (String location : locations) {
            String key = "client_web_fragments_" + location;
            if (this.webResourceIntegration.getRequestCache().containsKey(key)) continue;
            this.clientPageDataHandler.requirePageData(location, Collections.emptyMap());
            this.webResourceIntegration.getRequestCache().put(key, true);
        }
    }

    @VisibleForTesting
    Set<String> getWebSectionDependencies(Iterable<String> locations, Set<String> derivedLocations) {
        HashSet dependencies = Sets.newHashSet();
        HashSet sectionLocations = Sets.newHashSet(locations);
        HashSet prevSectionLocations = Sets.newHashSet(locations);
        while (prevSectionLocations.size() > 0) {
            HashSet newSectionLocations = Sets.newHashSet();
            for (String location : prevSectionLocations) {
                for (ClientWebSectionModuleDescriptor section : this.clientWebInterfaceManager.getSections(location)) {
                    String locationAndKey;
                    dependencies.add(section.getCompleteKey());
                    String key = section.getKey();
                    if (sectionLocations.add(key)) {
                        newSectionLocations.add(key);
                    }
                    if (!sectionLocations.add(locationAndKey = section.getLocation() + '/' + key)) continue;
                    newSectionLocations.add(locationAndKey);
                }
            }
            prevSectionLocations = newSectionLocations;
            if (derivedLocations == null) continue;
            derivedLocations.addAll(newSectionLocations);
        }
        return dependencies;
    }

    public List<String> getDependencies() {
        HashSet locations = Sets.newHashSet((Object[])new String[]{this.location});
        ArrayList dependencies = Lists.newArrayList((Iterable)super.getDependencies());
        if (this.fragmentType == FragmentType.ITEM || this.fragmentType == FragmentType.FRAGMENT) {
            dependencies.addAll(this.getWebItemDependencies(locations));
        }
        if (this.fragmentType == FragmentType.PANEL) {
            dependencies.addAll(this.getWebPanelDependencies(locations));
        }
        if (this.fragmentType == FragmentType.SECTION || this.fragmentType == FragmentType.FRAGMENT) {
            HashSet derivedLocations = Sets.newHashSet();
            dependencies.addAll(this.getWebSectionDependencies(locations, derivedLocations));
            dependencies.addAll(this.getWebItemDependencies(derivedLocations));
            dependencies.addAll(this.getWebPanelDependencies(derivedLocations));
            this.requirePageData(derivedLocations);
        }
        this.requirePageData(locations);
        return dependencies;
    }

    private static enum FragmentType {
        ITEM,
        SECTION,
        PANEL,
        FRAGMENT;

    }
}

