/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.ContextClassLoaderSettingInvocationHandler;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="pluginSettingsFactory")
@AvailableToPlugins(value=PluginSettingsFactory.class)
public class DefaultPluginSettingsFactory
implements PluginSettingsFactory {
    public static final String GLOBAL_SETTING_NAMESPACE = "bitbucket.global.settings";
    private final ApplicationContext applicationContext;
    private final PluginSettingDao pluginSettingDao;
    private final LoadingCache<String, PluginSettings> settingsForKey;
    private PluginSettings globalSettings;

    @Autowired
    public DefaultPluginSettingsFactory(final ApplicationContext applicationContext, final PluginSettingDao pluginSettingDao) {
        this.applicationContext = applicationContext;
        this.pluginSettingDao = pluginSettingDao;
        this.settingsForKey = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, PluginSettings>(){

            public PluginSettings load(@Nonnull String namespace) throws Exception {
                return (PluginSettings)Proxy.newProxyInstance(PluginSettings.class.getClassLoader(), new Class[]{PluginSettings.class}, (InvocationHandler)new ContextClassLoaderSettingInvocationHandler(applicationContext.getBean("pluginSettingsPrototype", new Object[]{pluginSettingDao, namespace})));
            }
        });
    }

    public PluginSettings createGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = (PluginSettings)this.settingsForKey.apply((Object)GLOBAL_SETTING_NAMESPACE);
        }
        return this.globalSettings;
    }

    public PluginSettings createSettingsForKey(String key) {
        try {
            return (PluginSettings)this.settingsForKey.getUnchecked((Object)key);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

