/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.sal.core.pluginsettings.AbstractStringPluginSettings;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pluginSettingsPrototype")
@Scope(value="prototype")
@Transactional
public class DefaultPluginSettings
extends AbstractStringPluginSettings {
    private final PluginSettingDao dao;
    private final String namespace;

    public DefaultPluginSettings(PluginSettingDao dao, String namespace) {
        this.dao = dao;
        this.namespace = namespace;
    }

    @Transactional(readOnly=true)
    public Object get(String key) {
        return super.get(key);
    }

    public Object put(String key, Object value) {
        return super.put(key, value);
    }

    public Object remove(String key) {
        return super.remove(key);
    }

    protected String getActual(String key) {
        return this.dao.get(this.namespace, key);
    }

    protected void putActual(String key, String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            this.dao.remove(this.namespace, key);
        } else {
            this.dao.put(this.namespace, key, val);
        }
    }

    protected void removeActual(String key) {
        this.dao.remove(this.namespace, key);
    }
}

