/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.stash.internal.home.FileMover;
import com.atlassian.stash.internal.home.HomeDirectoryMigrationException;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeFileMover
implements FileMover {
    private static final Logger log = LoggerFactory.getLogger(HomeFileMover.class);
    private final FileMover fileMover;

    public HomeFileMover(FileMover fileMover) {
        this.fileMover = fileMover;
    }

    @Override
    public void move(File source, File target) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (target.exists()) {
            throw new HomeDirectoryMigrationException("The '" + target.getName() + "' directory exists on both " + source.getAbsolutePath() + " and " + target.getAbsolutePath() + ".");
        }
        try {
            FileUtils.mkdir((File)target.getParentFile());
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            throw new HomeDirectoryMigrationException("'" + target.getParent() + "'  could not be created.", e);
        }
        log.info("Moving {} to {}", (Object)source.getAbsolutePath(), (Object)target.getAbsolutePath());
        this.fileMover.move(source, target);
        log.debug("Moving {} to {} successful", (Object)source.getAbsolutePath(), (Object)target.getAbsolutePath());
    }
}

