/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.applinks;

import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.integration.jira.applinks.LinkableEntityResolver;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=LinkableEntityResolver.class)
@Component(value="linkableEntityResolver")
public class ProjectEntityResolver
implements LinkableEntityResolver {
    private final ProjectService projectService;

    @Autowired
    public ProjectEntityResolver(ProjectService projectService) {
        this.projectService = projectService;
    }

    public Object resolve(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkArgument((!key.trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank entity key is required");
        return this.projectService.getByKey(key);
    }
}

