/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorConfigPage;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorItem;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorRequestItem;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorRequestPage;
import java.util.List;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class MirrorsAdminPage
extends BitbucketAdminPage {
    @ElementBy(id="mirroring-upstream-container")
    private PageElement mirrorAdminContainer;

    public MirrorsAdminPage() {
    }

    public MirrorsAdminPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public List<MirrorRequestItem> getMirrorRequests() {
        List mirrorRows = (List)Poller.waitUntil(this.getMirrorTableRows(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        return (List)mirrorRows.stream().filter(row -> row.find(By.cssSelector((String)"[data-testid='pending-lozenge']")).isPresent()).map(x$0 -> new SimpleMirrorRequestItem((PageElement)x$0)).collect(MoreCollectors.toImmutableList());
    }

    public TimedQuery<List<PageElement>> getMirrorTableRows() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.mirrorAdminContainer.findAll(By.cssSelector((String)"#mirroring-dashboard tbody tr")).stream().collect(MoreCollectors.toImmutableList()));
    }

    public List<MirrorItem> getMirrors() {
        List mirrorRows = (List)Poller.waitUntil(this.getMirrorTableRows(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        return (List)mirrorRows.stream().filter(row -> !row.find(By.cssSelector((String)"[data-testid='pending-lozenge']")).isPresent()).map(x$0 -> new SimpleMirrorItem((PageElement)x$0)).collect(MoreCollectors.toImmutableList());
    }

    public String getUrl() {
        return "/plugins/servlet/admin/mirrors";
    }

    public MirrorConfigPage selectMirror(String mirrorName) {
        return this.getMirrors().stream().filter(m -> m.getName().endsWith(mirrorName)).findAny().map(MirrorItem::click).orElseThrow(() -> new AssertionError((Object)("Mirror '" + mirrorName + "' was not present")));
    }

    private class SimpleMirrorItem
    implements MirrorItem {
        private final PageElement actionButton;
        private final PageElement element;

        private SimpleMirrorItem(PageElement element) {
            this.actionButton = element.find(By.cssSelector((String)"[data-testid='actions-button']"));
            this.element = element;
        }

        @Override
        public MirrorConfigPage click() {
            PageElement mirrorLink = this.element.find(By.cssSelector((String)".mirror-name a"), TimeoutType.UI_ACTION);
            String url = mirrorLink.getAttribute("href");
            mirrorLink.click();
            java.util.regex.Matcher m = Pattern.compile(Pattern.quote(MirrorsAdminPage.this.getUrl()) + "/(?<type>[^/]+)/(?<mirrorId>[^/]+)$").matcher(url);
            if (!m.find()) {
                throw new RuntimeException("Invalid URL: " + url);
            }
            return (MirrorConfigPage)MirrorsAdminPage.this.pageBinder.bind(MirrorConfigPage.class, new Object[]{m.group("type"), m.group("mirrorId")});
        }

        @Override
        public MirrorsAdminPage delete() {
            this.actionButton.click();
            PageElement deleteActionButton = MirrorsAdminPage.this.body.find(By.cssSelector((String)"[data-testid='mirror-actions-delete']"), TimeoutType.UI_ACTION);
            deleteActionButton.click();
            PageElement confirmButton = MirrorsAdminPage.this.body.find(By.cssSelector((String)"[data-testid='delete-mirror-modal-confirm-button']"));
            Poller.waitUntilTrue((TimedQuery)confirmButton.timed().isVisible());
            confirmButton.click();
            Poller.waitUntilFalse((TimedQuery)confirmButton.timed().isVisible());
            return (MirrorsAdminPage)MirrorsAdminPage.this.pageBinder.bind(MirrorsAdminPage.class, new Object[0]);
        }

        @Override
        public String getName() {
            return this.element.find(By.className((String)"mirror-name")).getText();
        }
    }

    private class SimpleMirrorRequestItem
    implements MirrorRequestItem {
        private final PageElement actionButton;
        private final PageElement element;

        private SimpleMirrorRequestItem(PageElement element) {
            this.actionButton = element.find(By.cssSelector((String)"[data-testid='actions-button']"));
            this.element = element;
        }

        @Override
        public MirrorRequestPage click() {
            this.actionButton.click();
            PageElement authorizeLink = MirrorsAdminPage.this.body.find(By.className((String)"mirror-authorize-link"));
            PageElement authorizeActionButton = authorizeLink.find(By.cssSelector((String)"[data-testid='mirror-actions-authorize']"));
            Poller.waitUntilTrue((TimedQuery)authorizeActionButton.timed().isPresent());
            String url = authorizeLink.getAttribute("href");
            java.util.regex.Matcher m = Pattern.compile(Pattern.quote(MirrorsAdminPage.this.getUrl()) + "/(?<type>[^/]+)/(?<mirrorId>[^/]+)/authorize/(?<requestId>[^/]+)$").matcher(url);
            if (!m.find()) {
                throw new RuntimeException("Invalid URL: " + url);
            }
            authorizeActionButton.click();
            Poller.waitUntilFalse((TimedQuery)this.actionButton.timed().isVisible());
            return (MirrorRequestPage)MirrorsAdminPage.this.pageBinder.bind(MirrorRequestPage.class, new Object[]{m.group("type"), m.group("mirrorId"), m.group("requestId")});
        }

        @Override
        public String getName() {
            return this.element.find(By.className((String)"mirror-name")).getText();
        }
    }
}

