/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.openqa.selenium.By;

public class UserPasswordResetConfirmPage
extends BitbucketPage {
    public static final String URL = "/passwordreset?token=";
    @ElementBy(cssSelector=".reset-password-confirm #password")
    private PageElement passwordTextbox;
    @ElementBy(cssSelector=".reset-password-confirm #confirmPassword")
    private PageElement passwordConfirmTextbox;
    @ElementBy(cssSelector=".reset-password-confirm #submit")
    private PageElement resetPasswordButton;
    private final String token;

    public UserPasswordResetConfirmPage(String token) {
        this.token = token;
    }

    public String getUrl() {
        return URL + this.token;
    }

    public boolean hasTokenNotFoundOrExpired() {
        return !this.driver.findElements(By.cssSelector((String)".aui-message-error.no-token-match")).isEmpty();
    }

    public boolean hasResetConfirmation() {
        return !this.driver.findElements(By.cssSelector((String)".aui-message-success.password-reseted")).isEmpty();
    }

    public UserPasswordResetConfirmPage setPassword(String text) {
        this.passwordTextbox.clear().type(new CharSequence[]{text});
        return this;
    }

    public UserPasswordResetConfirmPage setPasswordConfirmation(String text) {
        this.passwordConfirmTextbox.clear().type(new CharSequence[]{text});
        return this;
    }

    public UserPasswordResetConfirmPage clickResetPassword() {
        this.resetPasswordButton.click();
        return this;
    }
}

