/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.pageobjects.DelayedBinder;
import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.binder.PageBindingWaitException;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.page.HomePage;
import com.atlassian.pageobjects.page.LoginPage;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.SignUpPage;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.client.utils.URIBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketLegacyLoginPage
extends BitbucketPage
implements LoginPage {
    private static final Logger log = LoggerFactory.getLogger(BitbucketLegacyLoginPage.class);
    private final boolean embedded;
    private final boolean overrideNextParam;
    private final String permission;
    @ElementBy(id="captcha")
    private PageElement captcha;
    @ElementBy(id="captcha-image")
    private PageElement captchaImage;
    @ElementBy(id="captcha-reload")
    private PageElement captchaReloadButton;
    @ElementBy(name="j_password")
    private PageElement passwordField;
    @ElementBy(name="permission")
    private PageElement permissionField;
    @ElementBy(name="_atl_remember_me")
    private AuiCheckbox rememberMeCheckbox;
    @ElementBy(name="submit")
    private PageElement submitButton;
    @ElementBy(name="j_username")
    private PageElement usernameField;

    public BitbucketLegacyLoginPage() {
        this(true);
    }

    public BitbucketLegacyLoginPage(boolean overrideNextParam) {
        this(overrideNextParam, false, (String)null);
    }

    public BitbucketLegacyLoginPage(boolean overrideNextParam, boolean embedded, Permission permission) {
        this(overrideNextParam, embedded, permission.name());
    }

    public BitbucketLegacyLoginPage(boolean overrideNextParam, boolean embedded, String permission) {
        this.overrideNextParam = overrideNextParam;
        this.embedded = embedded;
        this.permission = permission;
    }

    public boolean canSignUp() {
        PageElement signUpLink = this.elementFinder.find(By.linkText((String)"Need an account? Sign up."));
        return (Boolean)signUpLink.timed().isPresent().byDefaultTimeout() != false && (Boolean)signUpLink.timed().isVisible().byDefaultTimeout() != false;
    }

    public void clickCaptchaReload() {
        this.captchaReloadButton.click();
    }

    public SignUpPage clickSignUp() {
        PageElement signUpLink = this.elementFinder.find(By.linkText((String)"Need an account? Sign up."));
        Poller.waitUntilTrue((TimedQuery)signUpLink.timed().isPresent());
        signUpLink.click();
        SignUpPage signUpPage = (SignUpPage)this.pageBinder.bind(SignUpPage.class, new Object[0]);
        Poller.waitUntilTrue((TimedQuery)signUpPage.isHereTimed());
        return signUpPage;
    }

    public String getCaptchImageSrc() {
        return this.captchaImage.getAttribute("src");
    }

    public String getPermission() {
        return (Boolean)this.permissionField.timed().isPresent().byDefaultTimeout() != false ? this.permissionField.getValue() : null;
    }

    public String getUrl() {
        try {
            URIBuilder uri = new URIBuilder("/login");
            if (this.embedded) {
                uri.addParameter("embedded", Boolean.TRUE.toString());
            }
            if (this.permission != null) {
                uri.addParameter("permission", this.permission);
            }
            return uri.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return (Boolean)this.usernameField.timed().isPresent().byDefaultTimeout() != false ? this.usernameField.getValue() : null;
    }

    public boolean hasSuccessfulSignUpMessage() {
        PageElement message = this.elementFinder.find(By.cssSelector((String)".aui-message-success.successful-signup"));
        return (Boolean)message.timed().isPresent().byDefaultTimeout() != false && (Boolean)message.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean isEmbedded() {
        return this.body.hasClass("user-login-embedded");
    }

    public <M extends Page> M login(String username, String password, Class<M> nextPage) {
        return this.login(username, password, false, nextPage, new Object[0]);
    }

    public <M extends Page> M login(String username, String password, Class<M> nextPage, Object ... args) {
        return this.login(username, password, false, nextPage, args);
    }

    public <M extends Page> M login(String username, String password, boolean rememberMe, Class<M> nextPage, Object ... args) {
        int i = 1;
        while (true) {
            try {
                this.usernameField.clear();
                this.usernameField.type(new CharSequence[]{username});
            }
            catch (NoSuchElementException e) {
                DelayedBinder delayedBinder = this.pageBinder.delayedBind(nextPage, args);
                if (this.driver.getCurrentUrl().contains(((Page)delayedBinder.get()).getUrl())) {
                    return this.bind(delayedBinder);
                }
                throw e;
            }
            try {
                return this.loginWithUserPreFilled(password, rememberMe, nextPage, args);
            }
            catch (PageBindingWaitException e) {
                if (i >= 3) {
                    throw e;
                }
                log.info("------------------------>>>> Attempt {} to login failed <<<<--------------------------", (Object)i, (Object)e);
                ++i;
                continue;
            }
            break;
        }
    }

    public <M extends Page> M loginAsRegularUser(Class<M> nextPage, Object ... args) {
        return this.login(DefaultFuncTestData.getRegularUser(), DefaultFuncTestData.getRegularUserPassword(), nextPage, args);
    }

    public <M extends Page> M loginAsSysAdmin(Class<M> nextPage) {
        return this.login(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), nextPage);
    }

    public <M extends Page> M loginAsSysAdmin(Class<M> nextPage, Object ... args) {
        return this.login(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), nextPage, args);
    }

    public BitbucketLegacyLoginPage loginFail(String username, String password, boolean rememberMe) {
        Poller.waitUntilTrue((TimedQuery)this.usernameField.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.passwordField.timed().isVisible());
        this.usernameField.clear();
        this.usernameField.type(new CharSequence[]{username});
        this.passwordField.type(new CharSequence[]{password});
        this.setRememberMe(rememberMe);
        this.submitButton.click();
        BitbucketLegacyLoginPage loginPage = (BitbucketLegacyLoginPage)this.pageBinder.bind(BitbucketLegacyLoginPage.class, new Object[0]);
        Poller.waitUntilTrue((TimedQuery)loginPage.isHereTimed());
        return loginPage;
    }

    public <M extends Page> M loginWithUserPreFilled(String password, boolean rememberMe, Class<M> nextPage, Object ... args) {
        this.passwordField.type(new CharSequence[]{password});
        this.setRememberMe(rememberMe);
        DelayedBinder delayedBinder = this.pageBinder.delayedBind(nextPage, args);
        if (!HomePage.class.isAssignableFrom(nextPage) && this.overrideNextParam) {
            this.javascriptExecutor.executeScript("(function() {const form = document.querySelector('form.aui');const next = form.querySelector('input[name=\"next\"]');if (next) {next.value = '" + StringEscapeUtils.escapeEcmaScript((String)((Page)delayedBinder.get()).getUrl()) + "';} else {const input = document.createElement('input');input.setAttribute('type', 'hidden');input.setAttribute('name', 'next');input.value = '" + StringEscapeUtils.escapeEcmaScript((String)((Page)delayedBinder.get()).getUrl()) + "';form.appendChild(input);}})()", new Object[0]);
        }
        this.submitButton.click();
        return this.bind(delayedBinder);
    }

    public BitbucketLegacyLoginPage setCaptcha(String captcha) {
        this.captcha.clear().type(new CharSequence[]{captcha});
        return this;
    }

    private <M extends Page> M bind(DelayedBinder<M> delayedBinder) {
        Page page = (Page)delayedBinder.bind();
        if (page instanceof AbstractPage) {
            AbstractPage abstractPage = (AbstractPage)page;
            Poller.waitUntilTrue((TimedQuery)abstractPage.isHereTimed());
        }
        return (M)page;
    }

    private void setRememberMe(boolean rememberMe) {
        if (!this.isEmbedded()) {
            Poller.waitUntilTrue((TimedQuery)this.rememberMeCheckbox.timed().isVisible());
            if (rememberMe) {
                this.rememberMeCheckbox.check();
            } else {
                this.rememberMeCheckbox.uncheck();
            }
        }
    }
}

