/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class DropdownMenu
extends AbstractElementPageObject {
    private final PageElement trigger;
    @Inject
    private PageElementFinder elementFinder;
    private String testId;

    public DropdownMenu(@Nonnull PageElement parentContainer, String testId) {
        super(parentContainer);
        this.trigger = this.find(By.cssSelector((String)("[data-testid='" + testId + "--trigger']")));
        this.testId = testId;
    }

    public void clickMenuItem(String itemName) {
        this.trigger.click();
        this.getMenuItemByName(itemName).click();
    }

    public PageElement getMenuItemByName(String itemName) {
        PageElement menu = this.elementFinder.find(By.cssSelector((String)("[data-testid='" + this.testId + "--content']")));
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)("[data-testid='" + this.testId + "--content'] [role='menuitem']"))).timed().isPresent());
        return menu.findAll(By.cssSelector((String)"[role='menuitem']")).stream().filter(menuItem -> itemName.equalsIgnoreCase(menuItem.getText())).findFirst().orElse(null);
    }

    public boolean isOpen() {
        return this.elementFinder.find(By.cssSelector((String)("[data-testid='" + this.testId + "--content']"))).isPresent();
    }

    public void toggleOpen() {
        this.trigger.click();
    }
}

