/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.git;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class SystemSigningAdminPage
extends BitbucketAdminPage {
    @ElementBy(className="cancel-button")
    private PageElement cancelButton;
    @ElementBy(className="system-signing-page-description")
    private PageElement description;
    @ElementBy(cssSelector="input[name='system-signed-status'][value='false']")
    private PageElement offRadioButton;
    @ElementBy(cssSelector="input[name='system-signed-status'][value='true']")
    private PageElement onRadioButton;
    @ElementBy(className="save-button")
    private PageElement saveButton;

    public SystemSigningAdminPage() {
    }

    public SystemSigningAdminPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    @WaitUntil
    public void ensurePageIsLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.description.timed().isVisible());
    }

    public SystemSigningAdminPage clickCancel() {
        Poller.waitUntilTrue((TimedQuery)this.cancelButton.timed().isEnabled());
        this.cancelButton.click();
        return this;
    }

    public SystemSigningAdminPage clickOff() {
        Poller.waitUntilTrue((TimedQuery)this.offRadioButton.timed().isVisible());
        this.offRadioButton.click();
        return this;
    }

    public SystemSigningAdminPage clickOn() {
        Poller.waitUntilTrue((TimedQuery)this.onRadioButton.timed().isVisible());
        this.onRadioButton.click();
        return this;
    }

    public SystemSigningAdminPage clickSave() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isEnabled());
        this.saveButton.click();
        return this;
    }

    public void dismissSuccessFlag() {
        Flag successAlert = (Flag)((List)Poller.waitUntil(this.getAllFlags(), (Matcher)Matchers.not((Matcher)Matchers.empty()))).get(0);
        MatcherAssert.assertThat((Object)successAlert.getTitle(), (Matcher)Matchers.equalTo((Object)"Your changes have been saved."));
        successAlert.dismiss();
    }

    public boolean isCancelButtonEnabled() {
        return this.cancelButton.isEnabled();
    }

    public boolean isOffRadioSelected() {
        return this.offRadioButton.isSelected();
    }

    public boolean isOnRadioSelected() {
        return this.onRadioButton.isSelected();
    }

    public boolean isSaveButtonEnabled() {
        return this.saveButton.isEnabled();
    }

    public String getUrl() {
        return "/admin/git/system-signing";
    }

    private TimedQuery<List<Flag>> getAllFlags() {
        return Queries.forSupplier((Timeouts)this.timeouts, this::getFlags);
    }
}

