/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.accesstokens;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.bitbucket.pageobjects.element.DropdownMenu;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.accesstokens.AccessTokenForm;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public abstract class AbstractAccessTokensPage
extends BitbucketAdminPage {
    protected final List<String> pathParts;

    public AbstractAccessTokensPage(List<String> pathParts) {
        this.pathParts = pathParts;
    }

    public AbstractAccessTokensPage(List<String> pathParts, String webSudoPassword) {
        super(webSudoPassword);
        this.pathParts = pathParts;
    }

    public AccessTokenRow getLatestAccessToken() {
        return this.getAccessTokenRows().findFirst().orElse(null);
    }

    public boolean hasActions(boolean value) {
        return this.getAccessTokenRows().allMatch(row -> value == row.hasActions());
    }

    public boolean hasToken(String tokenName) {
        return this.getAccessTokenRows().anyMatch(row -> tokenName.equals(row.getName()));
    }

    public abstract AbstractAccessTokensPage rebind();

    private Stream<AccessTokenRow> getAccessTokenRows() {
        return this.elementFinder.findAll(By.cssSelector((String)".access-token-row")).stream().map(ElementUtils.bind(this.pageBinder, AccessTokenRow.class, this));
    }

    public static class AccessTokenRow
    extends AbstractElementPageObject {
        private final PageElement actions;
        private final PageElement createdDate;
        private final PageElement expiryDate;
        private final PageElement lastAuthenticated;
        private final PageElement name;
        private final AbstractAccessTokensPage parentPage;
        private final PageElement permissions;
        @ElementBy(className="access-token-form")
        private PageElement accessTokenForm;
        @ElementBy(cssSelector="[data-testid='delete-access-token-modal']")
        private PageElement deleteDialog;

        public AccessTokenRow(@Nonnull PageElement container, AbstractAccessTokensPage parentPage) {
            super(container);
            this.parentPage = parentPage;
            this.createdDate = this.find(By.cssSelector((String)".col-created time"));
            this.expiryDate = this.find(By.cssSelector((String)".col-expiry time"));
            this.lastAuthenticated = this.find(By.cssSelector((String)".col-accessed time"));
            this.name = this.find(By.className((String)"col-name"));
            this.permissions = this.find(By.className((String)"col-permissions"));
            this.actions = this.find(By.className((String)"col-actions"));
        }

        public AccessTokenForm edit() {
            this.getActionsMenu().clickMenuItem("Edit");
            return (AccessTokenForm)this.pageBinder.bind(AccessTokenForm.class, new Object[]{this.accessTokenForm, this.parentPage});
        }

        public String getCreatedDate() {
            return this.createdDate.getAttribute("datetime");
        }

        public String getExpiryDate() {
            return this.expiryDate.isPresent() ? this.expiryDate.getAttribute("datetime") : null;
        }

        public Optional<String> getLastAuthenticated() {
            if (this.lastAuthenticated.isPresent()) {
                return Optional.ofNullable(this.lastAuthenticated.getAttribute("datetime"));
            }
            return Optional.empty();
        }

        public String getName() {
            return this.name.getText();
        }

        public List<Permission> getPermissions() {
            return this.permissions.findAll(By.className((String)"permission-value")).stream().map(element -> Permission.valueOf((String)element.getAttribute("data-permission"))).collect(Collectors.toList());
        }

        public boolean hasActions() {
            return this.actions.isPresent() || this.name.find(By.tagName((String)"button")).isPresent();
        }

        public AbstractAccessTokensPage delete() {
            this.getActionsMenu().clickMenuItem("Delete");
            ConfirmDialog deleteDialog = (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.deleteDialog});
            deleteDialog.clickButton("Delete");
            return this.parentPage.rebind();
        }

        private DropdownMenu getActionsMenu() {
            return (DropdownMenu)this.pageBinder.bind(DropdownMenu.class, new Object[]{this.container, "access-token-actions"});
        }
    }
}

